/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.ai;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.block.resin.vent.ResinVentBlock;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.AVPDeferredHolder;
import com.avp.common.registry.tag.AVPBlockTags;
import com.lib.common.data.Cooldown;
import java.time.Duration;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class CreateVentGoal
extends Goal {
    private static final int WALL_DEPTH = 3;
    private static final int WALL_TOTAL_DEPTH = 4;
    private final Cooldown cooldown;
    private final Xenomorph xenomorph;
    private final Level level;
    private BlockPos wallStart;
    private Direction direction;
    private boolean drillingStarted;

    public CreateVentGoal(Xenomorph xenomorph) {
        this.xenomorph = xenomorph;
        this.cooldown = Cooldown.withCooldownTime("cooldown", Duration.ofSeconds(15L));
        this.level = xenomorph.level();
        this.drillingStarted = false;
        this.cooldown.reset();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        this.cooldown.tick();
        if (this.isUnableToCreateVent()) {
            return false;
        }
        BlockPos footPos = this.xenomorph.blockPosition();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            HitResult hit = this.rayTraceToSolid(footPos, dir);
            if (!(hit instanceof BlockHitResult)) continue;
            BlockHitResult bhr = (BlockHitResult)hit;
            BlockPos hitPos = bhr.getBlockPos();
            boolean ventAlreadyExists = this.xenomorph.getHiveManager().hive().isSomeAnd(hive -> !hive.getVentManager().getVentsWithinSection(hitPos).isEmpty());
            if (ventAlreadyExists || !this.isValidWall(hitPos, dir)) continue;
            BlockPos pathTarget = hitPos.relative(dir, 3);
            Path path = this.xenomorph.getNavigation().createPath(pathTarget, 1);
            if (path == null || !path.canReach()) continue;
            this.wallStart = hitPos;
            this.direction = dir;
            return true;
        }
        return false;
    }

    public void start() {
        BlockPos pathTarget = this.wallStart.relative(this.direction, 3);
        this.xenomorph.getNavigation().moveTo((double)pathTarget.getX() + 0.5, (double)pathTarget.getY(), (double)pathTarget.getZ() + 0.5, 0.5);
    }

    public void tick() {
        if (this.drillingStarted || !this.xenomorph.getNavigation().isDone()) {
            return;
        }
        this.drillingStarted = true;
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.xenomorph);
        AVPDeferredHolder<Block> resinHolder = alienVariantType.resin();
        AVPDeferredHolder<ResinVentBlock> resinVentHolder = alienVariantType.resinVent();
        AVPDeferredHolder<Block> resinWebHolder = alienVariantType.resinWeb();
        for (int i = 0; i < 3; ++i) {
            BlockPos tunnelPos = this.wallStart.relative(this.direction, i);
            this.level.setBlock(tunnelPos, resinWebHolder.get().defaultBlockState(), 3);
            for (Direction adj : Direction.values()) {
                if (adj == this.direction || adj == this.direction.getOpposite()) continue;
                BlockPos tunnelWallPos = tunnelPos.relative(adj);
                this.level.setBlock(tunnelWallPos, resinHolder.get().defaultBlockState(), 3);
            }
        }
        BlockPos ventPos = this.wallStart.relative(this.direction, 3);
        this.level.setBlock(ventPos, resinVentHolder.get().defaultBlockState(), 3);
        this.cooldown.reset();
    }

    public boolean canContinueToUse() {
        return !this.isUnableToCreateVent() && !this.drillingStarted;
    }

    public void stop() {
        this.drillingStarted = false;
        this.wallStart = null;
        this.direction = null;
    }

    private boolean isUnableToCreateVent() {
        return this.xenomorph.getTarget() != null || this.xenomorph.getHiveManager().hive().isNoneOr(hive -> !hive.isAlive() || hive.isAngry() || !hive.getSpaceManager().isEntityWithinHive((Entity)this.xenomorph)) || this.cooldown.isActive();
    }

    private HitResult rayTraceToSolid(BlockPos start, Direction dir) {
        Vec3 from = Vec3.atCenterOf((Vec3i)start);
        Vec3 to = from.add(Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).scale(16.0));
        return this.level.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.xenomorph));
    }

    private boolean isValidWall(BlockPos start, Direction direction) {
        for (int i = 0; i < 3; ++i) {
            BlockPos tunnelPos = start.relative(direction, i);
            if (!this.isTunnelPosClear(tunnelPos)) {
                return false;
            }
            for (Direction adj : Direction.values()) {
                BlockPos tunnelWallPos;
                if (adj == direction || adj == direction.getOpposite() || this.isTunnelWallReplaceable(tunnelWallPos = tunnelPos.relative(adj))) continue;
                return false;
            }
        }
        BlockPos ventPos = start.relative(direction, 3);
        return this.isTunnelPosClear(ventPos);
    }

    private boolean isTunnelPosClear(BlockPos pos) {
        BlockState blockState = this.level.getBlockState(pos);
        return blockState.isAir() || this.isTunnelWallReplaceable(pos);
    }

    private boolean isTunnelWallReplaceable(BlockPos pos) {
        BlockState blockState = this.level.getBlockState(pos);
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(this.xenomorph);
        if (blockState.is(AVPBlockTags.XENOMORPH_IMMUNE)) {
            return false;
        }
        return blockState.is(alienVariantType.resin().get()) || blockState.is(alienVariantType.resinReplaceableTag());
    }
}

