/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.ai;

import com.alien.common.gameplay.entity.living.alien.EggCarrier;
import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class PickUpEggGoal<T extends Xenomorph>
extends Goal {
    private final T eggCarryingXenomorph;
    private Path path;

    public PickUpEggGoal(T eggCarryingXenomorph) {
        this.eggCarryingXenomorph = eggCarryingXenomorph;
    }

    public boolean canUse() {
        Ovomorph targetOvomorph = ((EggCarrier)this.eggCarryingXenomorph).getEggPickupManager().getTargetOvomorphOrNull();
        return targetOvomorph != null && targetOvomorph.wantsPickup && !targetOvomorph.isPassenger() && this.eggCarryingXenomorph.getTarget() == null;
    }

    public void start() {
        Ovomorph targetOvomorph = ((EggCarrier)this.eggCarryingXenomorph).getEggPickupManager().getTargetOvomorphOrNull();
        if (targetOvomorph != null) {
            this.path = this.eggCarryingXenomorph.getNavigation().createPath((Entity)targetOvomorph, 0);
        }
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.path != null && !this.path.isDone() && this.path.canReach();
    }

    public void tick() {
        Ovomorph targetOvomorph = ((EggCarrier)this.eggCarryingXenomorph).getEggPickupManager().getTargetOvomorphOrNull();
        if (targetOvomorph != null) {
            this.eggCarryingXenomorph.getNavigation().moveTo(this.path, 0.5);
            if (this.eggCarryingXenomorph.distanceToSqr((Entity)targetOvomorph) <= 4.0) {
                targetOvomorph.startRiding((Entity)this.eggCarryingXenomorph);
                ((EggCarrier)this.eggCarryingXenomorph).getEggPickupManager().setTargetOvomorph(null);
            }
        }
    }

    public void stop() {
        super.stop();
        this.path = null;
        ((EggCarrier)this.eggCarryingXenomorph).getEggPickupManager().setTargetOvomorph(null);
    }
}

