/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.node;

import com.alien.common.gameplay.block.entity.resin.node.ChargeCursorUtil;
import com.alien.common.gameplay.block.entity.resin.node.ResinSpreader;
import com.alien.common.gameplay.block.entity.resin.node.behavior.VeinSpreadBehavior;
import com.avp.common.registry.init.AVPSoundEvents;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ChargeCursor {
    private static final Codec<Set<Direction>> DIRECTION_SET = Direction.CODEC.listOf().xmap(list -> Sets.newEnumSet((Iterable)list, Direction.class), Lists::newArrayList);
    public static final Codec<ChargeCursor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(ChargeCursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(ChargeCursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(ChargeCursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(chargeCursor -> chargeCursor.updateDelayInTicks), (App)DIRECTION_SET.lenientOptionalFieldOf("facings").forGetter(chargeCursor -> Optional.ofNullable(chargeCursor.getFacingData()))).apply((Applicative)instance, ChargeCursor::new));
    private BlockPos pos;
    int charge;
    private int updateDelayInTicks;
    private int decayDelay;
    @Nullable
    private Set<Direction> facings;

    private ChargeCursor(BlockPos blockPos, int charge, int decayDelay, int updateDelayInTicks, Optional<Set<Direction>> facingsOptional) {
        this.pos = blockPos;
        this.charge = charge;
        this.decayDelay = decayDelay;
        this.updateDelayInTicks = updateDelayInTicks;
        this.facings = facingsOptional.orElse(null);
    }

    public ChargeCursor(BlockPos blockPos, int i) {
        this(blockPos, i, 1, 0, Optional.empty());
    }

    public void update(LevelAccessor levelAccessor, BlockPos nodePos, RandomSource randomSource, ResinSpreader resinSpreader) {
        if (!this.shouldUpdate(levelAccessor, nodePos)) {
            return;
        }
        if (this.updateDelayInTicks > 0) {
            --this.updateDelayInTicks;
            return;
        }
        BlockState blockState = levelAccessor.getBlockState(this.pos);
        VeinSpreadBehavior resinBehavior = ChargeCursorUtil.getSpreadBehavior(blockState);
        if (resinBehavior.attemptSpreadVein(nodePos, levelAccessor, this.pos, blockState, this.facings)) {
            if (resinBehavior.canChangeBlockStateOnSpread()) {
                blockState = levelAccessor.getBlockState(this.pos);
                resinBehavior = ChargeCursorUtil.getSpreadBehavior(blockState);
            }
            levelAccessor.playSound(null, this.pos, AVPSoundEvents.BLOCK_RESIN_SPREAD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.charge = resinBehavior.attemptUseCharge(this, levelAccessor, nodePos, randomSource, resinSpreader);
        if (this.charge > 0) {
            BlockPos validMovementPos = ChargeCursorUtil.getValidMovementPos(levelAccessor, this.pos, randomSource);
            if (validMovementPos != null) {
                this.pos = validMovementPos.immutable();
                blockState = levelAccessor.getBlockState(validMovementPos);
            }
            if (blockState.getBlock() instanceof VeinSpreadBehavior) {
                this.facings = MultifaceBlock.availableFaces((BlockState)blockState);
            }
            this.decayDelay = resinBehavior.updateDecayDelay(this.decayDelay);
            this.updateDelayInTicks = resinBehavior.getResinSpreadDelayInTicks();
        }
    }

    private boolean shouldUpdate(LevelAccessor levelAccessor, BlockPos blockPos) {
        ServerLevel serverLevel;
        return this.charge > 0 && levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).shouldTickBlocksAt(blockPos);
    }

    void mergeWith(ChargeCursor chargeCursor) {
        this.charge += chargeCursor.charge;
        chargeCursor.charge = 0;
        this.updateDelayInTicks = Math.min(this.updateDelayInTicks, chargeCursor.updateDelayInTicks);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getCharge() {
        return this.charge;
    }

    public int getDecayDelay() {
        return this.decayDelay;
    }

    @Nullable
    public Set<Direction> getFacingData() {
        return this.facings;
    }
}

