/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.node;

import com.alien.common.gameplay.block.entity.resin.node.behavior.ResinVeinSpreadBehavior;
import com.alien.common.gameplay.block.entity.resin.node.behavior.VeinSpreadBehavior;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ChargeCursorUtil {
    private static final BlockPos BOTTOM_LEFT = new BlockPos(-1, -1, -1);
    private static final BlockPos TOP_RIGHT = new BlockPos(1, 1, 1);
    private static final ObjectArrayList<Vec3i> NON_CORNER_NEIGHBOURS = (ObjectArrayList)Util.make((Object)new ObjectArrayList(18), objectArrayList -> BlockPos.betweenClosedStream((BlockPos)BOTTOM_LEFT, (BlockPos)TOP_RIGHT).filter(ChargeCursorUtil::isZeroAxis).map(BlockPos::immutable).forEach(arg_0 -> ((ObjectArrayList)objectArrayList).add(arg_0)));

    static VeinSpreadBehavior getSpreadBehavior(BlockState blockState) {
        VeinSpreadBehavior veinSpreadBehavior;
        Block block = blockState.getBlock();
        if (block instanceof VeinSpreadBehavior) {
            VeinSpreadBehavior veinSpreadBehavior2 = (VeinSpreadBehavior)block;
            veinSpreadBehavior = veinSpreadBehavior2;
        } else {
            veinSpreadBehavior = ResinVeinSpreadBehavior.INSTANCE;
        }
        return veinSpreadBehavior;
    }

    @Nullable
    static BlockPos getValidMovementPos(LevelAccessor levelAccessor, BlockPos blockPos, RandomSource randomSource) {
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.mutable();
        BlockPos.MutableBlockPos mutableBlockPos2 = blockPos.mutable();
        for (Vec3i vec3i : ChargeCursorUtil.getRandomizedNonCornerNeighbourOffsets(randomSource)) {
            mutableBlockPos2.setWithOffset((Vec3i)blockPos, vec3i);
            BlockState blockState = levelAccessor.getBlockState((BlockPos)mutableBlockPos2);
            if (!(blockState.getBlock() instanceof VeinSpreadBehavior) || !ChargeCursorUtil.isMovementUnobstructed(levelAccessor, blockPos, (BlockPos)mutableBlockPos2)) continue;
            mutableBlockPos.set((Vec3i)mutableBlockPos2);
            if (!SculkVeinBlock.hasSubstrateAccess((LevelAccessor)levelAccessor, (BlockState)blockState, (BlockPos)mutableBlockPos2)) continue;
            break;
        }
        return mutableBlockPos.equals((Object)blockPos) ? null : mutableBlockPos;
    }

    private static boolean isZeroAxis(BlockPos blockPos) {
        return (blockPos.getX() == 0 || blockPos.getY() == 0 || blockPos.getZ() == 0) && !blockPos.equals((Object)BlockPos.ZERO);
    }

    private static List<Vec3i> getRandomizedNonCornerNeighbourOffsets(RandomSource randomSource) {
        return Util.shuffledCopy(NON_CORNER_NEIGHBOURS, (RandomSource)randomSource);
    }

    private static boolean isMovementUnobstructed(LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (blockPos.distManhattan((Vec3i)blockPos2) == 1) {
            return true;
        }
        BlockPos blockPos3 = blockPos2.subtract((Vec3i)blockPos);
        Direction direction = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(blockPos3.getX() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
        Direction direction2 = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)(blockPos3.getY() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
        Direction direction3 = Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(blockPos3.getZ() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
        if (blockPos3.getX() == 0) {
            return ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction2) || ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction3);
        }
        return blockPos3.getY() == 0 ? ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction) || ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction3) : ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction) || ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction2);
    }

    private static boolean isUnobstructed(LevelAccessor levelAccessor, BlockPos blockPos, Direction direction) {
        BlockPos relativePos = blockPos.relative(direction);
        Direction opposite = direction.getOpposite();
        BlockState blockState = levelAccessor.getBlockState(relativePos);
        return !blockState.isFaceSturdy((BlockGetter)levelAccessor, relativePos, opposite);
    }
}

