/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.node;

import com.alien.common.gameplay.level.gameevent.listener.ResinSpreadListener;
import com.avp.common.registry.init.AVPBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import org.jetbrains.annotations.NotNull;

public class ResinNodeBlockEntity
extends BlockEntity
implements GameEventListener.Provider<ResinSpreadListener> {
    private final ResinSpreadListener resinSpreadListener;

    public ResinNodeBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(AVPBlockEntityTypes.RESIN_NODE.get(), blockPos, blockState);
        BlockPositionSource positionSource = new BlockPositionSource(blockPos);
        ResinSpreadListener.SpreaderType.Block spreaderType = new ResinSpreadListener.SpreaderType.Block(blockPos);
        this.resinSpreadListener = new ResinSpreadListener((PositionSource)positionSource, spreaderType);
    }

    public static void serverTick(Level level, BlockPos nodePos, BlockState blockState, ResinNodeBlockEntity resinNodeBlockEntity) {
        resinNodeBlockEntity.resinSpreadListener.getResinSpreader().updateCursors((LevelAccessor)level, nodePos, level.getRandom());
    }

    protected void loadAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.resinSpreadListener.getResinSpreader().load(compoundTag);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, @NotNull HolderLookup.Provider provider) {
        this.resinSpreadListener.getResinSpreader().save(compoundTag);
        super.saveAdditional(compoundTag, provider);
    }

    @NotNull
    public ResinSpreadListener getListener() {
        return this.resinSpreadListener;
    }
}

