/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.vent;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.level.gameevent.listener.CryForHelpListener;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.just.core.functional.option.Option;
import com.lib.common.data.Cooldown;
import java.time.Duration;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResinVentBlockEntity
extends BlockEntity
implements GameEventListener.Provider<CryForHelpListener> {
    private final Cooldown alienSpawnCooldown;
    private final CryForHelpListener cryForHelpListener;
    @Nullable
    private Hive hive;

    public ResinVentBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(AVPBlockEntityTypes.RESIN_VENT.get(), blockPos, blockState);
        BlockPositionSource positionSource = new BlockPositionSource(blockPos);
        this.alienSpawnCooldown = Cooldown.withCooldownTime("spawnAlienCooldown", Duration.ofSeconds(3L));
        this.cryForHelpListener = new CryForHelpListener((PositionSource)positionSource);
    }

    @Nullable
    public Hive getHive() {
        return this.hive;
    }

    public Cooldown getAlienSpawnCooldown() {
        return this.alienSpawnCooldown;
    }

    public void setHive(@Nullable Hive hive) {
        this.hive = hive;
    }

    public static void serverTick(Level level, BlockPos ventPos, BlockState blockState, ResinVentBlockEntity resinVentBlockEntity) {
        resinVentBlockEntity.getAlienSpawnCooldown().tick();
        Hive hive = resinVentBlockEntity.getHive();
        if (hive != null) {
            if (!hive.isAlive() || !hive.getSpaceManager().isBlockPosWithinHive(ventPos)) {
                resinVentBlockEntity.setHive(null);
                hive.getVentManager().removeVent(ventPos);
                return;
            }
            hive.getVentManager().addVent(ventPos);
            return;
        }
        if (level.getGameTime() % 20L == 0L) {
            Option<AlienVariantType> ventVariantTypeOption = AlienVariantTypes.getFor(blockState);
            if (ventVariantTypeOption.isNone()) {
                return;
            }
            AlienVariant ventAlienVariant = ((AlienVariantType)ventVariantTypeOption.unwrap()).variant();
            HiveLevelData.getOrCreate(level).andThen(hiveLevelData -> hiveLevelData.findNearestHive(ventPos, nearestHive -> Objects.equals((Object)nearestHive.getVariant(), (Object)ventAlienVariant))).filter(nearestHive -> nearestHive.isAlive() && nearestHive.getSpaceManager().isBlockPosWithinHive(ventPos)).ifSome(resinVentBlockEntity::setHive);
        }
    }

    @NotNull
    public CryForHelpListener getListener() {
        return this.cryForHelpListener;
    }
}

