/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.command.hive;

import com.alien.common.gameplay.hive.HiveSpaceManager;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.lib.common.gameplay.util.spatial.sphere.layer.SphereLayer;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;

public class CurrentHiveLayerCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"current").requires(CommandSourceStack::isPlayer)).executes(context -> {
            BlockPos playerPos = Objects.requireNonNull(((CommandSourceStack)context.getSource()).getPlayer()).blockPosition();
            HiveLevelData.getOrCreate((Level)((CommandSourceStack)context.getSource()).getLevel()).andThen(hiveLevelData -> hiveLevelData.findNearestHive(Objects.requireNonNull(((CommandSourceStack)context.getSource()).getPlayer()).blockPosition())).inspect(hive -> {
                SphereLayer currentLayer = hive.getSpaceManager().getLayerOrNull(playerPos);
                if (currentLayer == null) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"No layer found."), false);
                } else {
                    HiveSpaceManager.HiveLayer hiveLayer = hive.getSpaceManager().getHiveLayerOrNull(playerPos);
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Current hive layer: " + String.valueOf((Object)hiveLayer))), false);
                }
            }).ifNone(() -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"No nearby hive found."), false));
            return 1;
        });
    }
}

