/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.acid;

import com.alien.common.gameplay.entity.acid.Acid;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPBlockTags;
import com.avp.server.BlockBreakProgressManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class AcidBlockDamageUtil {
    public static void damageBlocks(Acid acid) {
        Level level = acid.level();
        BlockPos.betweenClosedStream((AABB)acid.getBoundingBox().inflate(0.0, 0.1, 0.0)).filter(blockPos -> AcidBlockDamageUtil.canAcidDestroyBlock(acid, blockPos, level)).forEach(blockPos -> AcidBlockDamageUtil.tryDestroyBlock(acid, blockPos, level));
    }

    private static void tryDestroyBlock(Acid acid, BlockPos blockPos, Level level) {
        if (!level.isClientSide) {
            if (acid.isInWater() || !acid.onGround()) {
                return;
            }
            AcidBlockDamageUtil.damageBlock(acid, blockPos, level);
        } else {
            AcidBlockDamageUtil.spawnClientSideParticles(acid, level);
        }
    }

    private static void damageBlock(Acid acid, BlockPos blockPos, Level level) {
        BlockBreakProgressManager.Result result = BlockBreakProgressManager.damage(level, blockPos, 0.2f * (float)acid.getMultiplier());
        switch (result) {
            case DAMAGED: {
                BlockPos above;
                if (!acid.isNetherAfflicted() || !level.getBlockState(above = blockPos.above()).isAir()) break;
                level.setBlockAndUpdate(above, Blocks.FIRE.defaultBlockState());
                break;
            }
            case DESTROYED: {
                if (!acid.isIrradiated()) break;
                level.setBlockAndUpdate(blockPos, Blocks.BLUE_ICE.defaultBlockState());
            }
        }
        if (result != BlockBreakProgressManager.Result.NOT_DAMAGED) {
            if (acid.tickCount % (acid.getRandom().nextInt(100) + 10) == 0) {
                level.playSound(null, (Entity)acid, AVPSoundEvents.BLOCK_ACID_BURN.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            acid.age();
        }
    }

    private static void spawnClientSideParticles(Acid acid, Level level) {
        if (acid.isIrradiated()) {
            return;
        }
        level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, acid.getRandomX(0.5), acid.getRandomY(), acid.getRandomZ(0.5), 0.0, 0.0, 0.0);
    }

    private static boolean canAcidDestroyBlock(Acid acid, BlockPos blockPos, Level level) {
        BlockState blockState = level.getBlockState(blockPos);
        if (blockState.isAir()) {
            return false;
        }
        if (acid.isNetherAfflicted()) {
            return !blockState.is(AVPBlockTags.NETHER_ACID_IMMUNE);
        }
        if (acid.isIrradiated()) {
            return !blockState.is(AVPBlockTags.IRRADIATED_ACID_IMMUNE);
        }
        return !blockState.is(AVPBlockTags.ACID_IMMUNE);
    }
}

