/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.HiveSpaceManager;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.just.core.functional.option.Option;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class AlienSpawning {
    private static final SpawnPlacements.SpawnPredicate<Alien> PREDICATE = (entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource) -> {
        BlockState belowState = serverLevelAccessor.getBlockState(blockPos.below());
        Option alienVariantTypeOption = AlienVariantTypes.getFor(entityType).map(AlienVariantType::resinBlockTag);
        boolean isValidResinPos = alienVariantTypeOption.isSomeAnd(arg_0 -> ((BlockState)belowState).is(arg_0));
        return isValidResinPos && AlienSpawning.checkSpawnRules((EntityType<? extends Monster>)entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource);
    };

    public static <T extends Alien> SpawnPlacements.SpawnPredicate<T> getTypedPredicate() {
        return PREDICATE;
    }

    public static boolean checkSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return Monster.checkMonsterSpawnRules(entityType, (ServerLevelAccessor)serverLevelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)randomSource) && AlienSpawning.canSpawnWithinNearestHive(entityType, serverLevelAccessor, blockPos);
    }

    private static boolean canSpawnWithinNearestHive(EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevelAccessor, BlockPos blockPos) {
        Option<AlienVariantType> alienVariantTypeOption = AlienVariantTypes.getFor(entityType);
        return HiveLevelData.getOrCreate((Level)serverLevelAccessor.getLevel()).andThen(hiveLevelData -> hiveLevelData.findNearestHive(blockPos, hive -> alienVariantTypeOption.isSomeAnd(alienVariantType -> Objects.equals((Object)hive.getVariant(), (Object)alienVariantType.variant())))).isSomeAnd(nearestHive -> nearestHive.isAlive() && AlienSpawning.canEntityTypeSpawnWithinHiveLayer(nearestHive, entityType, blockPos) && nearestHive.getReserveManager().canSpawn(entityType));
    }

    private static boolean canEntityTypeSpawnWithinHiveLayer(Hive nearestHive, EntityType<? extends Monster> entityType, BlockPos blockPos) {
        HiveSpaceManager.HiveLayer layer = nearestHive.getSpaceManager().getHiveLayerOrNull(blockPos);
        if (layer == null) {
            return false;
        }
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case HiveSpaceManager.HiveLayer.EDGE, HiveSpaceManager.HiveLayer.LEASH, HiveSpaceManager.HiveLayer.BUFFER -> false;
            case HiveSpaceManager.HiveLayer.WARRIOR -> entityType.is(AVPEntityTypeTags.SPAWNS_IN_HIVE_WARRIOR_LAYER);
            case HiveSpaceManager.HiveLayer.DRONE -> entityType.is(AVPEntityTypeTags.SPAWNS_IN_HIVE_DRONE_LAYER);
            case HiveSpaceManager.HiveLayer.PRAETORIAN -> entityType.is(AVPEntityTypeTags.SPAWNS_IN_HIVE_PRAETORIAN_LAYER);
            case HiveSpaceManager.HiveLayer.CENTER -> entityType.is(AVPEntityTypeTags.SPAWNS_IN_HIVE_QUEEN_LAYER);
        };
    }
}

