/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.just.core.functional.option.Option;
import com.just.core.functional.tuple.Tuple2;
import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.util.CompoundTagUtil;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HiveManager
implements NBTSerializable {
    private static final String HIVE_SIGNATURE_KEY = "HiveSignature";
    private final Alien alien;
    private Option<Hive> hiveOption;

    public HiveManager(Alien alien) {
        this.alien = alien;
        this.hiveOption = Option.none();
    }

    public void tick() {
        Level level = this.alien.level();
        if (level.isClientSide) {
            return;
        }
        if (this.hiveOption.isNone() && this.alien.tickCount % 200 == 0) {
            HiveLevelData.getOrCreate(level).map(hiveLevelData -> new Tuple2((Object)hiveLevelData, hiveLevelData.findNearestHive(this.alien.blockPosition(), hive -> Objects.equals((Object)this.alien.getVariant(), (Object)hive.getVariant())))).ifSome(tuple -> {
                HiveLevelData hiveLevelData = (HiveLevelData)((Object)((Object)tuple.v1()));
                ((Option)tuple.v2()).inspect(nearestHive -> {
                    boolean joinedHiveSuccessfully = this.tryJoinHive((Hive)nearestHive);
                    if (!joinedHiveSuccessfully) {
                        this.tryCreateAndAssignHive(hiveLevelData, (Hive)nearestHive);
                    }
                }).ifNone(() -> this.tryCreateAndAssignHive(hiveLevelData, null));
            });
        }
        this.hiveOption.ifSome(hive -> {
            if (!hive.isAlive() || !Objects.equals((Object)this.alien.getVariant(), (Object)hive.getVariant())) {
                hive.removeHiveMember((Entity)this.alien);
                this.hiveOption = Option.none();
                return;
            }
            if (this.alien.tickCount % 20 == 0) {
                hive.ping((Entity)this.alien);
                if (hive.getLeadershipManager().isLeader((Entity)this.alien)) {
                    hive.moveCenter(this.alien.blockPosition());
                }
            }
        });
        if (this.hiveOption.isSomeAnd(hive -> !hive.getMembershipManager().isMember((Entity)this.alien))) {
            this.hiveOption = Option.none();
        }
    }

    public boolean tryJoinHive(Hive hive) {
        boolean joinedHiveSuccessfully = hive.requestToJoin((Entity)this.alien);
        if (joinedHiveSuccessfully) {
            this.hiveOption = Option.some((Object)hive);
        }
        return joinedHiveSuccessfully;
    }

    private void tryCreateAndAssignHive(HiveLevelData hiveLevelData, @Nullable Hive nearestHive) {
        if (!this.alien.getType().is(AVPEntityTypeTags.XENOMORPHS)) {
            return;
        }
        if (nearestHive != null && nearestHive.getSpaceManager().isEntityWithinHiveBuffer((Entity)this.alien)) {
            return;
        }
        Hive newHive = hiveLevelData.createHive(this.alien);
        this.hiveOption = Option.some((Object)newHive);
    }

    @Override
    public void load(CompoundTag compoundTag) {
        if (!compoundTag.contains(HIVE_SIGNATURE_KEY)) {
            return;
        }
        this.hiveOption = HiveLevelData.getOrCreate(this.alien.level()).andThen(hiveLevelData -> {
            UUID hiveSignature = CompoundTagUtil.getUUIDOrNull(compoundTag, HIVE_SIGNATURE_KEY);
            return hiveSignature == null ? Option.none() : hiveLevelData.hive(hiveSignature);
        });
    }

    @Override
    public void save(CompoundTag compoundTag) {
        this.hiveOption.ifSome(hive -> compoundTag.putUUID(HIVE_SIGNATURE_KEY, hive.id()));
    }

    public Option<Hive> hive() {
        return this.hiveOption;
    }

    public Option<UUID> signature() {
        return this.hiveOption.map(Hive::id);
    }
}

