/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.chestburster;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.GrowthManager;
import com.alien.common.gameplay.entity.living.alien.chestburster.ChestbursterAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.registry.init.AlienEntityTypes;
import com.alien.common.util.AlienPredicates;
import com.alien.common.util.XenomorphGrowthUtil;
import com.avp.AVP;
import com.avp.common.util.AVPPredicates;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Chestburster
extends Alien {
    private final ChestbursterAnimationDispatcher animationDispatcher = new ChestbursterAnimationDispatcher(this);
    private final GrowthManager growthManager = new GrowthManager(this, XenomorphGrowthUtil.GROW_UP_CALLBACK).setGrowOverTime(true);

    public static AttributeSupplier.Builder createChestbursterAttributes() {
        return Chestburster.applyFrom(AVP.config.statsConfigs.CHESTBURSTER_STATS, Monster.createMonsterAttributes());
    }

    public Chestburster(EntityType<? extends Chestburster> entityType, Level level) {
        super(entityType, level);
        this.config = AVP.config.statsConfigs.CHESTBURSTER_STATS;
    }

    @Override
    @Nullable
    public EntityType<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Chestburster.getType(alienVariant, this.isRoyal());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 8.0f, 1.0, 1.2, entity -> {
            boolean bl;
            if (entity instanceof Alien) {
                Alien alien = (Alien)entity;
                bl = AlienPredicates.areAliensEnemies(this, alien);
            } else {
                bl = !AVPPredicates.IS_IMMORTAL.test((LivingEntity)entity);
            }
            return bl;
        }));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
    }

    @Override
    public void tick() {
        super.tick();
        this.growthManager.tick();
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.CHESTBURSTER_STATS.healthRegenPerSecond;
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.growthManager.load(compoundTag);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.growthManager.save(compoundTag);
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return 1;
    }

    public ChestbursterAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    @Nullable
    public static EntityType<? extends Alien> getType(AlienVariant alienVariant, boolean isRoyal) {
        if (isRoyal) {
            return switch (alienVariant) {
                default -> throw new MatchException(null, null);
                case AlienVariant.NORMAL -> AlienEntityTypes.ROYAL_CHESTBURSTER.get();
                case AlienVariant.NETHER -> AlienEntityTypes.ROYAL_NETHER_CHESTBURSTER.get();
                case AlienVariant.ABERRANT -> AlienEntityTypes.ROYAL_ABERRANT_CHESTBURSTER.get();
                case AlienVariant.IRRADIATED -> null;
            };
        }
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.CHESTBURSTER.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_CHESTBURSTER.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_CHESTBURSTER.get();
            case AlienVariant.IRRADIATED -> null;
        };
    }
}

