/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.ovomorph;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.ovomorph.HatchDesireManager;
import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.parasite.facehugger.Facehugger;
import com.alien.common.model.alien.HatchState;
import com.avp.AVP;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.init.AVPSoundEvents;
import com.lib.common.network.DataAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public class HatchManager {
    private final HatchDesireManager hatchDesireManager;
    private final Ovomorph ovomorph;
    private final DataAccessor<Integer> remainingHatchDurationInTicks;
    private final DataAccessor<Integer> remainingSpawnDelayInTicks;
    private final DataAccessor<Integer> spawnCount;

    public HatchManager(Ovomorph ovomorph, int hatchDurationInTicks, int spawnDelayInTicks) {
        this.hatchDesireManager = new HatchDesireManager(ovomorph);
        this.ovomorph = ovomorph;
        this.remainingHatchDurationInTicks = new DataAccessor<Integer>(ovomorph, AVPDataKeys.OVOMORPH_HATCH_DURATION_IN_TICKS);
        this.remainingHatchDurationInTicks.set(hatchDurationInTicks);
        this.remainingSpawnDelayInTicks = new DataAccessor<Integer>(ovomorph, AVPDataKeys.OVOMORPH_REMAINING_SPAWN_DELAY_IN_TICKS);
        this.remainingSpawnDelayInTicks.set(spawnDelayInTicks);
        this.spawnCount = new DataAccessor<Integer>(ovomorph, AVPDataKeys.OVOMORPH_SPAWN_COUNT);
    }

    public void tick() {
        boolean canSpawnMoreFacehuggers;
        this.hatchDesireManager.tick();
        Level level = this.ovomorph.level();
        if (level.isClientSide || !this.ovomorph.isAlive() || this.ovomorph.isDeadOrDying()) {
            return;
        }
        if (this.isHatching()) {
            this.remainingHatchDurationInTicks.set(Math.max(this.remainingHatchDurationInTicks.get() - 1, 0));
        }
        if (!this.isReadyToSpawnFacehuggers()) {
            return;
        }
        this.ovomorph.setHatchState(HatchState.HATCHED);
        boolean bl = canSpawnMoreFacehuggers = this.spawnCount.get() < this.ovomorph.maxSpawnCount.get();
        if (!canSpawnMoreFacehuggers) {
            return;
        }
        this.remainingSpawnDelayInTicks.set(Math.max(this.remainingSpawnDelayInTicks.get() - 1, 0));
        if (this.remainingSpawnDelayInTicks.get() == 0) {
            this.spawnFacehugger(level);
            this.remainingSpawnDelayInTicks.reset();
            this.spawnCount.set(this.spawnCount.get() + 1);
        }
    }

    public boolean isReadyToSpawnFacehuggers() {
        return this.remainingHatchDurationInTicks.get() <= 0;
    }

    public boolean isHatching() {
        return this.ovomorph.getHatchState().contains((Object)HatchState.HATCHING);
    }

    public boolean isHatched() {
        return this.ovomorph.getHatchState().contains((Object)HatchState.HATCHED);
    }

    public void hatch() {
        if (this.isHatching() || this.isHatched()) {
            return;
        }
        this.ovomorph.setHatchState(HatchState.HATCHING);
        this.ovomorph.level().playSound(null, (Entity)this.ovomorph, AVPSoundEvents.ENTITY_OVOMORPH_HATCH.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    public void restore() {
        this.spawnCount.reset();
        this.remainingHatchDurationInTicks.reset();
        this.remainingSpawnDelayInTicks.reset();
        this.ovomorph.setHatchState(Ovomorph.DEFAULT_HATCH_STATE);
    }

    public HatchDesireManager getHatchDesireManager() {
        return this.hatchDesireManager;
    }

    private void spawnFacehugger(Level level) {
        EntityType<? extends Alien> facehuggerType = Facehugger.getType(this.ovomorph.getVariant(), this.ovomorph.isRoyal());
        if (facehuggerType == null) {
            AVP.LOGGER.warn("Failed to get a facehugger type for an ovomorph entity Ovomorph Variant: {}, IsRoyal: {}.", (Object)this.ovomorph.getVariant(), (Object)this.ovomorph.isRoyal());
            return;
        }
        Alien facehugger = (Alien)facehuggerType.create(level);
        if (facehugger == null) {
            AVP.LOGGER.warn("Failed to create facehugger entity.");
            return;
        }
        this.ovomorph.getGeneManager().getGeneContainer().transfer(facehugger.getGeneManager().getGeneContainer(), false);
        BlockPos ovomorphAbovePos = this.ovomorph.blockPosition().above();
        boolean ovomorphSuffocatingAboveCheck = this.ovomorph.level().getBlockState(ovomorphAbovePos).isSuffocating((BlockGetter)this.ovomorph.level(), ovomorphAbovePos);
        double ovomorphYPos = ovomorphSuffocatingAboveCheck ? this.ovomorph.position().y : this.ovomorph.position().y + (double)this.ovomorph.getBbHeight();
        facehugger.setPos(this.ovomorph.position().x, ovomorphYPos, this.ovomorph.position().z);
        facehugger.setYRot(this.ovomorph.getYRot());
        facehugger.setXRot(this.ovomorph.getXRot());
        facehugger.yBodyRot = this.ovomorph.yBodyRot;
        facehugger.yHeadRot = this.ovomorph.yHeadRot;
        facehugger.setPersistenceRequired();
        if (!ovomorphSuffocatingAboveCheck) {
            facehugger.setDeltaMovement(Mth.nextFloat((RandomSource)facehugger.getRandom(), (float)-0.5f, (float)0.5f), 0.7, Mth.nextFloat((RandomSource)facehugger.getRandom(), (float)-0.5f, (float)0.5f));
        }
        level.addFreshEntity((Entity)facehugger);
    }
}

