/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.ovomorph;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.ovomorph.HatchManager;
import com.alien.common.gameplay.entity.living.alien.ovomorph.OvomorphAnimationDispatcher;
import com.alien.common.gameplay.entity.living.alien.ovomorph.ai.OvomorphGOAP;
import com.alien.common.model.alien.HatchState;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.registry.AVPDeferredHolder;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.entity.manager.VibrationSystemManager;
import com.lib.common.network.DataAccessor;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ovomorph
extends Alien
implements Shearable {
    public static final HatchState DEFAULT_HATCH_STATE = HatchState.SLEEPING;
    public final DataAccessor<Byte> hatchStateId = new DataAccessor<Byte>(this, AVPDataKeys.OVOMORPH_HATCH_STATE);
    public final DataAccessor<Byte> maxSpawnCount = new DataAccessor<Byte>(this, AVPDataKeys.OVOMORPH_MAXIMUM_SPAWN_COUNT);
    public final DataAccessor<Boolean> isRooted = new DataAccessor<Boolean>(this, AVPDataKeys.OVOMORPH_IS_ROOTED);
    private final OvomorphAnimationDispatcher animationDispatcher = new OvomorphAnimationDispatcher(this);
    private final OvomorphGOAP goap = new OvomorphGOAP(this);
    private final HatchManager hatchManager = new HatchManager(this, 60, 60);
    public boolean pickupRequestAcknowledged;
    public boolean wantsPickup;

    public static AttributeSupplier.Builder createOvomorphAttributes() {
        return Ovomorph.applyFrom(AVP.config.statsConfigs.OVOMORPH_STATS, Monster.createMonsterAttributes());
    }

    public Ovomorph(EntityType<? extends Ovomorph> entityType, Level level) {
        super(entityType, level);
        this.config = AVP.config.statsConfigs.OVOMORPH_STATS;
        this.wantsPickup = false;
    }

    @Override
    @Nullable
    public EntityType<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Ovomorph.getType(alienVariant, this.isRoyal());
    }

    @Override
    protected VibrationSystemManager createVibrationSystemManager() {
        return new VibrationSystemManager((Mob)this, 2.5f, 8);
    }

    @Override
    public void tick() {
        super.tick();
        this.hatchManager.tick();
        if (!this.level().isClientSide) {
            AlienVariantType alienVariantType;
            AVPDeferredHolder<GameEvent> deferredHolder;
            this.goap.update(this);
            this.wantsPickup = this.canBePickedUp();
            if (!this.pickupRequestAcknowledged && this.wantsPickup && this.tickCount % 20 == 0 && (deferredHolder = (alienVariantType = AlienVariantTypes.getFor(this)).eggPickupRequestEvent()) != null) {
                this.gameEvent(deferredHolder.getHolder());
            }
            if (this.isPassenger()) {
                this.pickupRequestAcknowledged = false;
            }
        }
    }

    public boolean canBeHeld() {
        return this.isAlive() && !this.isDeadOrDying() && this.isRooted.get() == false && this.getHatchState().contains((Object)HatchState.SLEEPING);
    }

    public boolean canBePickedUp() {
        return this.canBeHeld() && this.onGround() && !this.isPassenger();
    }

    public void tryHatch() {
        if (!(this.level().isClientSide || this.hatchManager.isHatching() || this.hatchManager.isHatched() || this.isIrradiated())) {
            this.hatchManager.hatch();
        }
    }

    @NotNull
    public InteractionResult mobInteract(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (this.level().isClientSide) {
            return super.mobInteract(player, interactionHand);
        }
        ItemStack itemStack = player.getItemInHand(interactionHand);
        Item resinBallItem = AlienVariantTypes.getFor(this).resinBall().get();
        if (this.isRooted.get().booleanValue() && itemStack.is(Items.SHEARS)) {
            this.shear(SoundSource.PLAYERS);
            this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
            itemStack.hurtAndBreak(1, (LivingEntity)player, Ovomorph.getSlotForHand((InteractionHand)interactionHand));
            return InteractionResult.SUCCESS;
        }
        if (!this.isRooted.get().booleanValue() && itemStack.is(resinBallItem)) {
            this.level().playSound(null, (Entity)this, AVPSoundEvents.ENTITY_OVOMORPH_ROOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.isRooted.set(true);
            itemStack.consume(1, (LivingEntity)player);
        }
        return super.mobInteract(player, interactionHand);
    }

    public void shear(@NotNull SoundSource soundSource) {
        this.isRooted.set(false);
        this.level().playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, soundSource, 1.0f, 1.0f);
        this.level().playSound(null, (Entity)this, AVPSoundEvents.ENTITY_OVOMORPH_SHEAR.get(), soundSource, 1.0f, 1.0f);
        Item resinBallItem = AlienVariantTypes.getFor(this).resinBall().get();
        ItemEntity itemEntity = this.spawnAtLocation((ItemLike)resinBallItem, 1);
        if (itemEntity != null) {
            itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }

    public boolean readyForShearing() {
        return this.isRooted.get();
    }

    @Override
    public boolean hurt(@NotNull DamageSource damageSource, float damage) {
        boolean isHurt = super.hurt(damageSource, damage);
        if (!this.level().isClientSide && isHurt && damageSource.getEntity() != null) {
            this.tryHatch();
        }
        return isHurt;
    }

    protected void doPush(@NotNull Entity entity) {
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
            super.doPush(entity);
            return;
        }
        if (AVPPredicates.isFreeHost(this, entity)) {
            this.tryHatch();
        }
        if (!entity.getType().is(AVPEntityTypeTags.ALIENS) || entity.getType().is(AVPEntityTypeTags.OVOMORPHS)) {
            super.doPush(entity);
        }
    }

    @Override
    protected boolean canBleedAcid() {
        return !this.hatchManager.isHatching() && !this.hatchManager.isHatched();
    }

    public boolean isPushedByFluid() {
        return this.isRooted.get() == false;
    }

    public boolean isPushable() {
        return this.isRooted.get() == false;
    }

    @Override
    public boolean isPersistenceRequired() {
        if (this.hatchManager.isHatched()) {
            return super.isPersistenceRequired();
        }
        return super.isPersistenceRequired() || this.isRooted.get() == false;
    }

    @Override
    protected boolean canHeal() {
        return !this.hatchManager.isHatching() && !this.hatchManager.isHatched() && super.canHeal();
    }

    @Override
    protected boolean canAlienRideVehicle(@NotNull Entity vehicle) {
        return this.isRooted.get() == false;
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.OVOMORPH_STATS.healthRegenPerSecond;
    }

    public HatchManager getHatchManager() {
        return this.hatchManager;
    }

    public Option<HatchState> getHatchState() {
        byte id = this.hatchStateId.get();
        return Option.ofNullable((Object)((Object)HatchState.ID_TO_HATCH_STATE_MAP.get(id)));
    }

    public void setHatchState(HatchState hatchState) {
        this.hatchStateId.set((byte)hatchState.getId());
    }

    public OvomorphAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    @Nullable
    public static EntityType<? extends Ovomorph> getType(AlienVariant alienVariant, boolean isRoyal) {
        if (isRoyal) {
            return switch (alienVariant) {
                default -> throw new MatchException(null, null);
                case AlienVariant.NORMAL -> AlienEntityTypes.ROYAL_OVOMORPH.get();
                case AlienVariant.NETHER -> AlienEntityTypes.ROYAL_NETHER_OVOMORPH.get();
                case AlienVariant.ABERRANT -> AlienEntityTypes.ROYAL_ABERRANT_OVOMORPH.get();
                case AlienVariant.IRRADIATED -> null;
            };
        }
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.OVOMORPH.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_OVOMORPH.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_OVOMORPH.get();
            case AlienVariant.IRRADIATED -> null;
        };
    }
}

