/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.AVPDeferredHolder;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EggPickupRequestListener
implements GameEventListener {
    private final PositionSource positionSource;
    private final Consumer<Ovomorph> onRequestReceived;

    public EggPickupRequestListener(Entity entity, Consumer<Ovomorph> onRequestReceived) {
        this.onRequestReceived = onRequestReceived;
        this.positionSource = new EntityPositionSource(entity, 0.0f);
    }

    @NotNull
    public PositionSource getListenerSource() {
        return this.positionSource;
    }

    public int getListenerRadius() {
        return 16;
    }

    public boolean handleGameEvent(@NotNull ServerLevel serverLevel, @NotNull Holder<GameEvent> holder, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull GameEvent.Context context, @NotNull Vec3 vec3) {
        Entity sourceEntity = context.sourceEntity();
        if (!(sourceEntity instanceof Ovomorph)) {
            return false;
        }
        Ovomorph ovomorph = (Ovomorph)sourceEntity;
        AlienVariantType alienVariantType = AlienVariantTypes.getFor(ovomorph);
        AVPDeferredHolder<GameEvent> deferredHolder = alienVariantType.eggPickupRequestEvent();
        if (deferredHolder == null || !holder.is(deferredHolder.getHolder()) || ovomorph.pickupRequestAcknowledged || !ovomorph.wantsPickup) {
            return false;
        }
        this.onRequestReceived.accept(ovomorph);
        return true;
    }

    @NotNull
    public GameEventListener.DeliveryMode getDeliveryMode() {
        return GameEventListener.DeliveryMode.BY_DISTANCE;
    }
}

