/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.GrowthManager;
import com.alien.common.gameplay.entity.living.alien.ResinManager;
import com.alien.common.gameplay.entity.living.alien.xenomorph.XenomorphNavigationManager;
import com.alien.common.model.resin.ResinData;
import com.alien.common.model.resin.ResinProducer;
import com.alien.common.util.AlienPredicates;
import com.alien.common.util.XenomorphGrowthUtil;
import com.avp.common.gameplay.ai.goal.DigToTargetGoal;
import com.avp.common.gameplay.ai.goal.StrollAroundInWaterGoal;
import com.avp.common.gameplay.ai.goal.XenoFloatGoal;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.lib.common.gameplay.entity.manager.CrawlingManager;
import com.lib.common.network.DataAccessor;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Xenomorph
extends Alien
implements ResinProducer {
    public final DataAccessor<Boolean> isCrawling = new DataAccessor<Boolean>(this, AVPDataKeys.XENOMORPH_IS_CRAWLING);
    protected final CrawlingManager crawlingManager = new CrawlingManager((PathfinderMob)this, this.isCrawling);
    private final XenomorphNavigationManager navigationManager;
    private final GrowthManager growthManager = new GrowthManager(this, XenomorphGrowthUtil.GROW_UP_CALLBACK).setGrowOverTime(false);
    private final ResinManager resinManager;
    private boolean wasUnderwaterLastTick = false;

    public Xenomorph(EntityType<? extends Xenomorph> entityType, Level level) {
        super(entityType, level);
        this.navigationManager = new XenomorphNavigationManager(this, this.moveControl);
        this.resinManager = new ResinManager(this, this.createResinData());
        this.isCrawling.onChange($ -> this.refreshDimensions());
    }

    protected double getPursuitSpeedModifier() {
        return 1.1;
    }

    protected int getAttackDelayInTicks() {
        return 5;
    }

    protected boolean canTargetInitially(LivingEntity target) {
        return true;
    }

    @Nullable
    protected abstract ResinData createResinData();

    public abstract void runAttackAnimations();

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new XenoFloatGoal((Mob)this));
        this.addDigToTargetGoal();
        this.goalSelector.addGoal(7, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Xenomorph.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> AlienPredicates.canTarget(this, target) && this.canTargetInitially((LivingEntity)target)));
    }

    protected void addDigToTargetGoal() {
        this.goalSelector.addGoal(5, (Goal)new DigToTargetGoal((Mob)this, 32.0, 2, () -> true));
    }

    @Override
    public void tick() {
        LivingEntity target;
        super.tick();
        this.crawlingManager.tick();
        this.growthManager.tick();
        this.resinManager.tick();
        this.updateDimensionsBasedOnWaterState();
        if (!this.level().isClientSide && (target = this.getTarget()) != null && !AlienPredicates.canContinueTargeting(this, target)) {
            this.setTarget(null);
        }
    }

    private void updateDimensionsBasedOnWaterState() {
        if (this.wasUnderwaterLastTick != this.isUnderWater()) {
            this.refreshDimensions();
        }
        this.wasUnderwaterLastTick = this.isUnderWater();
    }

    public void travel(@NotNull Vec3 vec3) {
        if (this.isControlledByLocalInstance() && this.isUnderWater()) {
            this.moveRelative(0.01f, vec3);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(vec3);
        }
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.isUnderWater()) {
                this.navigationManager.switchToWater(this, 4, this.goalSelector);
                this.setSwimming(true);
            } else {
                this.navigationManager.switchToGround(this, 4, this.goalSelector);
                this.setSwimming(false);
            }
        }
    }

    public boolean startRiding(@NotNull Entity entity, boolean force) {
        if (entity instanceof Boat || entity instanceof Minecart) {
            return false;
        }
        return super.startRiding(entity, force);
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        EntityDimensions defaultDimensions = this.getType().getDimensions();
        boolean shouldBeSmall = this.crawlingManager.isCrawling() || this.isUnderWater();
        return defaultDimensions.scale(1.0f, shouldBeSmall ? 0.4f : 1.0f);
    }

    @Override
    public void updateDynamicGameEventListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> biConsumer) {
        super.updateDynamicGameEventListener(biConsumer);
        this.resinManager.updateDynamicGameEventListener(biConsumer);
    }

    public boolean canDisableShield() {
        return true;
    }

    public float getWalkTargetValue(@NotNull BlockPos blockPos, @NotNull LevelReader levelReader) {
        return 0.0f;
    }

    public boolean updateFluidHeightAndDoFluidPushing(@NotNull TagKey<Fluid> tagKey, double d) {
        double modifier = d;
        if (Objects.equals(tagKey, FluidTags.WATER)) {
            modifier = 0.0;
        }
        if (this.isNetherAfflicted() && Objects.equals(tagKey, FluidTags.LAVA)) {
            modifier = 0.0;
        }
        return super.updateFluidHeightAndDoFluidPushing(tagKey, modifier);
    }

    @Override
    public void setTarget(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null && !livingEntity.equals((Object)this.getTarget()) && this.ambientSoundTime > this.getAmbientSoundInterval()) {
            this.playSound(AVPSoundEvents.ENTITY_XENOMORPH_HISS.get(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        super.setTarget(livingEntity);
    }

    public boolean canAttack(@NotNull LivingEntity target) {
        return super.canAttack(target) && AlienPredicates.canContinueTargeting(this, target);
    }

    protected void doPush(Entity entity) {
        if (!(entity.getType().is(AVPEntityTypeTags.FACEHUGGERS) || entity.getType().is(AVPEntityTypeTags.CHESTBURSTERS) || entity.getType().is(AVPEntityTypeTags.ADOLESCENTS))) {
            super.doPush(entity);
        }
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.getTarget() != null ? AVPSoundEvents.ENTITY_XENOMORPH_HISS.get() : AVPSoundEvents.ENTITY_XENOMORPH_IDLE.get();
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        return AVPSoundEvents.ENTITY_XENOMORPH_DEATH.get();
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource damageSource) {
        return AVPSoundEvents.ENTITY_XENOMORPH_HURT.get();
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.crawlingManager.load(compoundTag);
        this.growthManager.load(compoundTag);
        this.resinManager.load(compoundTag);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        this.crawlingManager.save(compoundTag);
        this.growthManager.save(compoundTag);
        this.resinManager.save(compoundTag);
    }

    public GrowthManager getGrowthManager() {
        return this.growthManager;
    }

    @Override
    public ResinManager getResinManager() {
        return this.resinManager;
    }

    public CrawlingManager getCrawlingManager() {
        return this.crawlingManager;
    }

    public void setMoveControl(MoveControl moveControl) {
        this.moveControl = moveControl;
    }

    public void setNavigation(PathNavigation navigation) {
        this.navigation = navigation;
    }
}

