/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.praetorian;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.praetorian.PraetorianAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.registry.init.AVPSoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Praetorian
extends Xenomorph {
    private final PraetorianAnimationDispatcher animationDispatcher = new PraetorianAnimationDispatcher(this);

    public static AttributeSupplier.Builder createPraetorianAttributes() {
        return Praetorian.applyFrom(AVP.config.statsConfigs.PRAETORIAN_STATS, Monster.createMonsterAttributes());
    }

    public Praetorian(EntityType<? extends Praetorian> entityType, Level level) {
        super((EntityType<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.PRAETORIAN_STATS;
    }

    @Override
    @Nullable
    public EntityType<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Praetorian.getType(alienVariant);
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return new ResinData(0, 64, 1, AVP.config.statsConfigs.PRAETORIAN_STATS.nestTickrate);
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.PRAETORIAN_STATS.healthRegenPerSecond;
    }

    @Override
    public void runAttackAnimations() {
        int attackType = this.random.nextInt(0, 3);
        this.playSound(AVPSoundEvents.ENTITY_XENOMORPH_ATTACK.get(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        switch (attackType) {
            case 0: {
                this.animationDispatcher.rightClawAttack();
                break;
            }
            case 1: {
                this.animationDispatcher.biteAttack();
                break;
            }
            default: {
                this.animationDispatcher.tailAttack();
            }
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return 9;
    }

    public PraetorianAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public static EntityType<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.PRAETORIAN.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_PRAETORIAN.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_PRAETORIAN.get();
            case AlienVariant.IRRADIATED -> AlienEntityTypes.IRRADIATED_PRAETORIAN.get();
        };
    }
}

