/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.prowler;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.prowler.ProwlerAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.gameplay.ai.goal.combat.LungeAtTargetGoal;
import com.avp.common.registry.init.AVPSoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Prowler
extends Xenomorph {
    private final ProwlerAnimationDispatcher animationDispatcher = new ProwlerAnimationDispatcher(this);

    public static AttributeSupplier.Builder createProwlerAttributes() {
        return Prowler.applyFrom(AVP.config.statsConfigs.PROWLER_STATS, Monster.createMonsterAttributes());
    }

    public Prowler(EntityType<? extends Prowler> entityType, Level level) {
        super((EntityType<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.PROWLER_STATS;
    }

    @Override
    @Nullable
    public EntityType<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Prowler.getType(alienVariant);
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return new ResinData(0, 16, 1, AVP.config.statsConfigs.PROWLER_STATS.nestTickrate);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(3, (Goal)new LungeAtTargetGoal((Mob)this, 0.05f, 140, 6.0, 12.0).setOnLungeCallback(this::runLungeAnimation));
    }

    @Override
    protected double getPursuitSpeedModifier() {
        return 1.2;
    }

    @Override
    public void runAttackAnimations() {
        int attackType = this.random.nextInt(0, 3);
        this.playSound(AVPSoundEvents.ENTITY_XENOMORPH_ATTACK.get(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        switch (attackType) {
            case 0: {
                this.animationDispatcher.rightClawAttack();
                break;
            }
            case 1: {
                this.animationDispatcher.biteAttack();
                break;
            }
            default: {
                this.animationDispatcher.tailAttackQuad();
            }
        }
    }

    private void runLungeAnimation() {
        this.playSound(AVPSoundEvents.ENTITY_XENOMORPH_LUNGE.get(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        this.animationDispatcher.lunge();
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.PROWLER_STATS.healthRegenPerSecond;
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return 2;
    }

    public ProwlerAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public static EntityType<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.PROWLER.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_PROWLER.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_PROWLER.get();
            case AlienVariant.IRRADIATED -> AlienEntityTypes.IRRADIATED_PROWLER.get();
        };
    }
}

