/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.ai.task.impl.balance;

import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.ai.task.impl.balance.BalanceHiveTask;
import com.alien.common.gameplay.hive.membership.HiveReserveManager;
import com.alien.common.model.hive.HiveMemberData;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class BalanceAveragingHiveTask
extends BalanceHiveTask {
    private final Supplier<EntityType<?>> baseUnitTypeSupplier;
    private final Supplier<EntityType<?>> desiredUnitTypeSupplier;

    public BalanceAveragingHiveTask(Hive hive, Supplier<EntityType<?>> baseUnitTypeSupplier, Supplier<EntityType<?>> desiredUnitTypeSupplier) {
        super(hive);
        this.baseUnitTypeSupplier = baseUnitTypeSupplier;
        this.desiredUnitTypeSupplier = desiredUnitTypeSupplier;
    }

    @Override
    public void run() {
        this.balanceReserveUnits();
        this.balanceLoadedUnits();
    }

    private void balanceReserveUnits() {
        int currentDesiredUnitCount;
        HiveReserveManager reserveManager = this.hive.getReserveManager();
        EntityType<?> baseUnitType = this.baseUnitTypeSupplier.get();
        EntityType<?> desiredUnitType = this.desiredUnitTypeSupplier.get();
        int baseUnitCount = reserveManager.getCount(baseUnitType);
        int desiredUnitCount = this.computeDesiredUnitCount(baseUnitCount, currentDesiredUnitCount = reserveManager.getCount(desiredUnitType));
        if (desiredUnitCount == 0) {
            return;
        }
        reserveManager.add(baseUnitType, -desiredUnitCount);
        reserveManager.add(desiredUnitType, desiredUnitCount);
    }

    private void balanceLoadedUnits() {
        List desiredUnits;
        Map<EntityType<?>, List<Map.Entry<UUID, HiveMemberData>>> membersByType = this.hive.getMembershipManager().getMembersByEntityType();
        EntityType<?> baseEntityType = this.baseUnitTypeSupplier.get();
        EntityType<?> desiredEntityType = this.desiredUnitTypeSupplier.get();
        List baseUnits = membersByType.getOrDefault(baseEntityType, List.of());
        int baseUnitCount = baseUnits.size();
        int desiredUnitCount = this.computeDesiredUnitCount(baseUnitCount, (desiredUnits = membersByType.getOrDefault(desiredEntityType, List.of())).size());
        if (desiredUnitCount == 0) {
            return;
        }
        int offset = Math.max(baseUnitCount - desiredUnitCount, 0);
        baseUnits.stream().sorted(Comparator.comparingInt(a -> ((HiveMemberData)a.getValue()).lastSeenTimestampInTicks())).toList().subList(offset, baseUnitCount).forEach(entry -> {
            Entity baseUnit = ((ServerLevel)this.hive.level()).getEntity((UUID)entry.getKey());
            if (!(baseUnit instanceof Xenomorph)) {
                return;
            }
            Xenomorph xenomorph = (Xenomorph)baseUnit;
            this.growXenomorph(xenomorph);
        });
    }

    private int computeDesiredUnitCount(int baseUnitCount, int desiredUnitCount) {
        return Math.max(0, (baseUnitCount - desiredUnitCount) / 2);
    }
}

