/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.ai.task.impl.balance;

import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.ai.task.impl.balance.BalanceHiveTask;
import com.alien.common.gameplay.hive.membership.HiveReserveManager;
import com.alien.common.model.hive.HiveMemberData;
import com.avp.AVP;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class BalanceStepHiveTask
extends BalanceHiveTask {
    private static final Predicate<EntityType<?>> XENOMORPH_PREDICATE = entityType -> entityType.is(AVPEntityTypeTags.XENOMORPHS);
    private final Supplier<EntityType<?>> baseUnitTypeSupplier;
    private final Supplier<EntityType<?>> desiredUnitTypeSupplier;

    public BalanceStepHiveTask(Hive hive, Supplier<EntityType<?>> baseUnitTypeSupplier, Supplier<EntityType<?>> desiredUnitTypeSupplier) {
        super(hive);
        this.baseUnitTypeSupplier = baseUnitTypeSupplier;
        this.desiredUnitTypeSupplier = desiredUnitTypeSupplier;
    }

    @Override
    public void run() {
        this.balanceReserveUnits();
        this.balanceLoadedUnits();
    }

    private void balanceReserveUnits() {
        HiveReserveManager reserveManager = this.hive.getReserveManager();
        int reserveXenomorphCount = reserveManager.getCountMatching(XENOMORPH_PREDICATE);
        EntityType<?> baseUnitType = this.baseUnitTypeSupplier.get();
        EntityType<?> desiredUnitType = this.desiredUnitTypeSupplier.get();
        int currentBaseUnitCount = reserveManager.getCount(baseUnitType);
        int currentDesiredUnitCount = reserveManager.getCount(desiredUnitType);
        int desiredUnitCount = this.computeDesiredUnitCount(reserveXenomorphCount, currentDesiredUnitCount);
        if ((desiredUnitCount = Math.min(currentBaseUnitCount, desiredUnitCount)) == 0) {
            return;
        }
        reserveManager.add(baseUnitType, -desiredUnitCount);
        reserveManager.add(desiredUnitType, desiredUnitCount);
    }

    private void balanceLoadedUnits() {
        Map<EntityType<?>, List<Map.Entry<UUID, HiveMemberData>>> membersByType = this.hive.getMembershipManager().getMembersByEntityType();
        int xenomorphHiveMemberCount = this.hive.getMembershipManager().getMembersMatching(XENOMORPH_PREDICATE).size();
        EntityType<?> baseEntityType = this.baseUnitTypeSupplier.get();
        EntityType<?> desiredEntityType = this.desiredUnitTypeSupplier.get();
        List baseUnits = membersByType.getOrDefault(baseEntityType, List.of());
        int baseUnitCount = baseUnits.size();
        List desiredUnits = membersByType.getOrDefault(desiredEntityType, List.of());
        int currentDesiredUnitCount = desiredUnits.size();
        int desiredUnitCount = this.computeDesiredUnitCount(xenomorphHiveMemberCount, currentDesiredUnitCount);
        if (desiredUnitCount == 0) {
            return;
        }
        int offset = Math.max(baseUnitCount - desiredUnitCount, 0);
        baseUnits.stream().sorted(Comparator.comparingInt(a -> ((HiveMemberData)a.getValue()).lastSeenTimestampInTicks())).toList().subList(offset, baseUnitCount).forEach(entry -> {
            Entity baseUnit = ((ServerLevel)this.hive.level()).getEntity((UUID)entry.getKey());
            if (!(baseUnit instanceof Xenomorph)) {
                return;
            }
            Xenomorph xenomorph = (Xenomorph)baseUnit;
            this.growXenomorph(xenomorph);
        });
    }

    private int computeDesiredUnitCount(int xenomorphHiveMemberCount, int desiredUnitCount) {
        int hiveMembersRequiredForPraetorian = AVP.config.hiveConfigs.HIVE_MEMBERS_REQUIRED_FOR_PRAETORIAN;
        int maxPraetorianCount = AVP.config.hiveConfigs.HIVE_MAX_PRAETORIAN_COUNT;
        return hiveMembersRequiredForPraetorian > 0 ? Math.max(0, Math.clamp((long)(xenomorphHiveMemberCount / hiveMembersRequiredForPraetorian), 0, maxPraetorianCount) - desiredUnitCount) : 0;
    }
}

