/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.membership;

import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.membership.HiveMembershipCache;
import com.alien.common.model.hive.HiveMemberData;
import com.avp.AVP;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.NBTSerializable;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class HiveMembershipManager
implements NBTSerializable {
    private static final String HIVE_MEMBER_DATA_KEY = "HiveMemberData";
    private static final int MEMBERSHIP_PURGE_FREQUENCY = 1200;
    private final Hive hive;
    private final HiveMembershipCache hiveMembershipCache;

    public HiveMembershipManager(Hive hive) {
        this.hive = hive;
        this.hiveMembershipCache = new HiveMembershipCache();
    }

    public void tick() {
        if (this.hive.ageInTicks() % 1200 == 0) {
            this.purgeUnresponsiveHiveMembers();
        }
    }

    private void purgeUnresponsiveHiveMembers() {
        this.hiveMembershipCache.removeIf(hiveMemberEntry -> {
            HiveMemberData hiveMemberData = (HiveMemberData)hiveMemberEntry.getValue();
            int lastSeenTimestampInTicks = hiveMemberData.lastSeenTimestampInTicks();
            BlockPos lastSeenPos = hiveMemberData.lastSeenPos();
            boolean isLastSeenPosLoaded = this.hive.level().isLoaded(lastSeenPos);
            if (!isLastSeenPosLoaded) {
                return true;
            }
            return this.hive.ageInTicks() - lastSeenTimestampInTicks > 3600;
        });
    }

    public void clearMembers() {
        this.hiveMembershipCache.clear();
    }

    public void addMember(Entity entity) {
        ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        HiveMemberData hiveMemberData = new HiveMemberData(resourceLocation, entity.blockPosition(), this.hive.ageInTicks());
        this.addMember(entity.getUUID(), hiveMemberData);
    }

    public void addMember(UUID entityUUID, HiveMemberData hiveMemberData) {
        this.hiveMembershipCache.add(entityUUID, hiveMemberData);
    }

    public boolean isMember(Entity entity) {
        return this.isMember(entity.getUUID());
    }

    public boolean isMember(UUID uuid) {
        return this.hiveMembershipCache.has(uuid);
    }

    public void removeMember(Entity entity) {
        this.hiveMembershipCache.remove(entity.getUUID());
    }

    public Set<UUID> getMemberUUIDs() {
        return this.hiveMembershipCache.streamEntries().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public int getMemberCount() {
        return this.hiveMembershipCache.size();
    }

    public List<Entity> getLoadedMembers() {
        Level level = this.hive.level();
        return level.isClientSide ? List.of() : this.hiveMembershipCache.streamEntries().map(Map.Entry::getKey).map(arg_0 -> ((ServerLevel)((ServerLevel)level)).getEntity(arg_0)).filter(Objects::nonNull).toList();
    }

    @NotNull
    public Option<HiveMemberData> getMemberData(@Nullable Entity entity) {
        if (entity == null) {
            return Option.none();
        }
        return this.getMemberData(entity.getUUID());
    }

    @NotNull
    public Option<HiveMemberData> getMemberData(@Nullable UUID uuid) {
        if (uuid == null) {
            return Option.none();
        }
        return this.hiveMembershipCache.get(uuid);
    }

    public Map<EntityType<?>, List<Map.Entry<UUID, HiveMemberData>>> getMembersByEntityType() {
        return this.hiveMembershipCache.getMembersByEntityTypeMap();
    }

    public Collection<Map.Entry<UUID, HiveMemberData>> getMembersMatching(Predicate<EntityType<?>> predicate) {
        return this.hiveMembershipCache.getMembersByEntityTypeMap().keySet().stream().filter(predicate).map(this.hiveMembershipCache::getMembersByEntityType).flatMap(Collection::stream).toList();
    }

    @Override
    public void load(CompoundTag compoundTag) {
        CompoundTag hiveMemberDataMapTag = compoundTag.getCompound(HIVE_MEMBER_DATA_KEY);
        for (String key : hiveMemberDataMapTag.getAllKeys()) {
            UUID entityUUID = UUID.fromString(key);
            CompoundTag hiveMemberDataTag = hiveMemberDataMapTag.getCompound(key);
            HiveMemberData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)hiveMemberDataTag)).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(hiveMemberData -> this.hiveMembershipCache.add(entityUUID, hiveMemberData));
        }
    }

    @Override
    public void save(CompoundTag compoundTag) {
        CompoundTag hiveMemberDataTag = new CompoundTag();
        this.hiveMembershipCache.streamEntries().forEach(entry -> HiveMemberData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((HiveMemberData)entry.getValue())).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(tag -> hiveMemberDataTag.put(((UUID)entry.getKey()).toString(), tag)));
        compoundTag.put(HIVE_MEMBER_DATA_KEY, (Tag)hiveMemberDataTag);
    }
}

