/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.util;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.Host;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.just.core.functional.option.Option;
import com.lib.common.model.GeneCarrier;
import com.lib.common.util.EmbryoUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlienEmbryoUtil {
    public static void runAlienEmbryoRoutines(LivingEntity hostEntity) {
        Player player;
        Host host = (Host)hostEntity;
        Level level = hostEntity.level();
        if (level.isClientSide) {
            return;
        }
        if (hostEntity instanceof Player && ((player = (Player)hostEntity).isCreative() || player.isSpectator() || player.isInvulnerable())) {
            host.removeEmbryo();
            return;
        }
        if (host.getEmbryoType().isSome()) {
            AlienEmbryoUtil.tickAlienEmbryoGrowth(hostEntity);
        } else {
            host.removeEmbryo();
        }
    }

    private static void tickAlienEmbryoGrowth(LivingEntity hostEntity) {
        Host host = (Host)hostEntity;
        if (hostEntity.level().getDifficulty() == Difficulty.PEACEFUL) {
            host.removeEmbryo();
            return;
        }
        host.incrementEmbryoGrowthTimeInTicks();
        long burstTimeInTicks = TimeUnit.MINUTES.toSeconds(5L) * 20L;
        if ((long)host.getEmbryoGrowthTimeInTicks() <= burstTimeInTicks) {
            if (hostEntity instanceof Player) {
                Player player = (Player)hostEntity;
                if ((long)host.getEmbryoGrowthTimeInTicks() > TimeUnit.MINUTES.toSeconds(4L) * 20L + 600L) {
                    hostEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 80, 1, true, false, true));
                    if (player.tickCount % 10 == 0) {
                        player.playNotifySound(AVPSoundEvents.EFFECT_HEARTBEAT_3.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    }
                } else if ((long)host.getEmbryoGrowthTimeInTicks() > TimeUnit.MINUTES.toSeconds(4L) * 20L) {
                    if (player.tickCount % 20 == 0) {
                        player.playNotifySound(AVPSoundEvents.EFFECT_HEARTBEAT_2.get(), SoundSource.MASTER, 0.75f, 1.0f);
                    }
                } else if ((long)host.getEmbryoGrowthTimeInTicks() > TimeUnit.MINUTES.toSeconds(3L) * 20L + 600L) {
                    if (player.tickCount % 30 == 0) {
                        player.playNotifySound(AVPSoundEvents.EFFECT_HEARTBEAT_1.get(), SoundSource.MASTER, 0.5f, 1.0f);
                    }
                } else if ((long)host.getEmbryoGrowthTimeInTicks() > TimeUnit.MINUTES.toSeconds(3L) * 20L && player.tickCount % 40 == 0) {
                    player.playNotifySound(AVPSoundEvents.EFFECT_HEARTBEAT_0.get(), SoundSource.MASTER, 0.25f, 1.0f);
                }
            }
            if ((long)host.getEmbryoGrowthTimeInTicks() >= burstTimeInTicks - 160L && hostEntity.tickCount % 10 == 0) {
                hostEntity.level().playSound(null, (Entity)hostEntity, AVPSoundEvents.EFFECT_BONE_CRUNCH.get(), SoundSource.HOSTILE, 0.2f, 1.0f);
                hostEntity.hurt(hostEntity.damageSources().source(AVPDamageTypeKeys.CHESTBURSTING), 0.01f);
            }
            return;
        }
        List<Entity> embryos = AlienEmbryoUtil.birthEmbryos(hostEntity);
        embryos.forEach(embryo -> {});
        hostEntity.level().playSound(null, (Entity)hostEntity, AVPSoundEvents.ENTITY_CHESTBURSTER_BURST.get(), SoundSource.HOSTILE, 0.25f, 1.0f);
        hostEntity.hurt(hostEntity.damageSources().source(AVPDamageTypeKeys.CHESTBURSTING), Float.MAX_VALUE);
        host.removeEmbryo();
    }

    public static List<Entity> birthEmbryos(LivingEntity parentEntity) {
        return EmbryoUtil.birthEmbryos(parentEntity, ((Host)parentEntity).getOrCreateParasiteGeneContainer(), AlienEmbryoUtil::alienEmbryoFactory, 1);
    }

    @Nullable
    public static Entity alienEmbryoFactory(@NotNull LivingEntity hostEntity) {
        Level level = hostEntity.level();
        Host host = (Host)hostEntity;
        Option<EntityType<?>> embryoTypeOption = host.getEmbryoType();
        if (embryoTypeOption.isNone()) {
            return null;
        }
        Entity embryo = ((EntityType)embryoTypeOption.unwrap()).create(level);
        if (embryo == null) {
            return null;
        }
        if (embryo instanceof Mob) {
            Mob mob = (Mob)embryo;
            mob.setPersistenceRequired();
        }
        if (embryo instanceof Alien) {
            Alien alien = (Alien)embryo;
            EmbryoUtil.applyGenesToEmbryo(hostEntity.getType(), host.getOrCreateParasiteGeneContainer(), (GeneCarrier)((Object)alien), true);
            alien.setHostType(hostEntity.getType());
        }
        embryo.moveTo(hostEntity.position(), hostEntity.getYRot(), hostEntity.getXRot());
        embryo.setYRot(hostEntity.getYRot());
        embryo.setXRot(hostEntity.getXRot());
        if (embryo instanceof LivingEntity) {
            LivingEntity livingEmbryo = (LivingEntity)embryo;
            for (MobEffectInstance effect : hostEntity.getActiveEffects()) {
                livingEmbryo.addEffect(new MobEffectInstance(effect.getEffect(), Integer.MAX_VALUE, effect.getAmplifier(), false, false));
            }
        }
        level.addFreshEntity(embryo);
        return embryo;
    }
}

