/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.data.worldgen.builder;

import com.avp.AVPResources;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RepeatingPlacement;

public record AVPOreData(String name, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureKey, ResourceKey<PlacedFeature> placedFeatureKey, OreConfiguration oreConfiguration, List<PlacementModifier> modifiers) {
    private static final Comparator<PlacementModifier> MODIFIER_COMPARATOR = Comparator.comparingInt(mod -> {
        PlacementModifier placementModifier = mod;
        Objects.requireNonNull(placementModifier);
        PlacementModifier selector0$temp = placementModifier;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RepeatingPlacement.class, InSquarePlacement.class, HeightRangePlacement.class, PlacementFilter.class}, (Object)selector0$temp, index$1)) {
            case 0 -> {
                RepeatingPlacement $ = (RepeatingPlacement)selector0$temp;
                yield 1;
            }
            case 1 -> {
                InSquarePlacement $ = (InSquarePlacement)selector0$temp;
                yield 2;
            }
            case 2 -> {
                HeightRangePlacement $ = (HeightRangePlacement)selector0$temp;
                yield 3;
            }
            case 3 -> {
                PlacementFilter $ = (PlacementFilter)selector0$temp;
                yield 4;
            }
            default -> Integer.MAX_VALUE;
        };
    });

    public ConfiguredFeature<OreConfiguration, Feature<OreConfiguration>> createConfiguredFeature() {
        return new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)this.oreConfiguration);
    }

    public PlacedFeature createPlacedFeature(HolderGetter<ConfiguredFeature<?, ?>> holder) {
        return new PlacedFeature((Holder)holder.getOrThrow(this.configuredFeatureKey), this.modifiers);
    }

    public static Builder builder(String name, OreConfiguration.TargetBlockState targetBlockState) {
        return AVPOreData.builder(name, List.of(targetBlockState));
    }

    public static Builder builder(String name, List<OreConfiguration.TargetBlockState> targetBlockStates) {
        return new Builder(name, targetBlockStates);
    }

    public static class Builder {
        private final String name;
        private final List<OreConfiguration.TargetBlockState> targetBlockStates;
        private final List<PlacementModifier> modifiers;
        private int veinSize;
        private float normalizedAirDiscardChance;

        private Builder(String name, List<OreConfiguration.TargetBlockState> targetBlockStates) {
            this.name = name;
            this.targetBlockStates = new ArrayList<OreConfiguration.TargetBlockState>(targetBlockStates);
            this.modifiers = new ArrayList<PlacementModifier>();
            this.normalizedAirDiscardChance = 0.0f;
            this.veinSize = 9;
        }

        public Builder normalizedAirDiscardChance(float normalizedAirDiscardChance) {
            this.normalizedAirDiscardChance = normalizedAirDiscardChance;
            return this;
        }

        public Builder target(OreConfiguration.TargetBlockState targetBlockState) {
            this.targetBlockStates.add(targetBlockState);
            return this;
        }

        public Builder veinSize(int veinSize) {
            this.veinSize = veinSize;
            return this;
        }

        public Builder biomeFilter(BiomeFilter biomeFilter) {
            this.modifiers.add((PlacementModifier)biomeFilter);
            return this;
        }

        public Builder count(int count) {
            this.modifiers.add((PlacementModifier)CountPlacement.of((int)count));
            return this;
        }

        public Builder heightRange(HeightRangePlacement heightRangePlacement) {
            this.modifiers.add((PlacementModifier)heightRangePlacement);
            return this;
        }

        public Builder spread() {
            this.modifiers.add((PlacementModifier)InSquarePlacement.spread());
            return this;
        }

        public AVPOreData build() {
            ResourceLocation resourceLocation = AVPResources.location(this.name);
            ResourceKey configuredFeatureKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)resourceLocation);
            ResourceKey placedFeatureKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)resourceLocation);
            OreConfiguration oreConfiguration = new OreConfiguration(this.targetBlockStates, this.veinSize, this.normalizedAirDiscardChance);
            this.modifiers.sort(MODIFIER_COMPARATOR);
            return new AVPOreData(this.name, configuredFeatureKey, (ResourceKey<PlacedFeature>)placedFeatureKey, oreConfiguration, this.modifiers);
        }
    }
}

