/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.ai.goal;

import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.alien.common.model.alien.variant.AlienVariant;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.lib.common.model.GeneCarrier;
import com.lib.common.model.GeneDecayLevelType;
import com.lib.common.util.GeneIntegrityUtil;
import java.util.concurrent.TimeUnit;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class QueenLayEggGoal
extends Goal {
    private static final int MAX_EGG_LAY_COOLDOWN_IN_TICKS = (int)TimeUnit.MINUTES.toSeconds(1L) * 20;
    private static final int MAX_EGG_COUNT_IN_HIVE = 60;
    private final Queen queen;
    private int eggLayCooldownInTicks;

    public QueenLayEggGoal(Queen queen) {
        this.queen = queen;
        this.eggLayCooldownInTicks = MAX_EGG_LAY_COOLDOWN_IN_TICKS;
    }

    public boolean canUse() {
        if (this.eggLayCooldownInTicks > 0) {
            --this.eggLayCooldownInTicks;
            return false;
        }
        return this.queen.isAlive() && this.queen.getOvipositorManager().hasOvipositor() && !this.queen.isIrradiated() && this.queen.getHiveManager().hive().isSomeAnd(hive -> hive.isAlive() && hive.getSpaceManager().isEntityWithinHive((Entity)this.queen) && hive.getMembershipManager().getMembersMatching(member -> member.is(AVPEntityTypeTags.OVOMORPHS)).size() < 60) && this.noEggsNearby();
    }

    public void start() {
        Ovomorph ovomorph;
        this.eggLayCooldownInTicks = MAX_EGG_LAY_COOLDOWN_IN_TICKS;
        Level level = this.queen.level();
        boolean isRoyal = this.queen.getRandom().nextInt(100) < 5;
        AlienVariant variant = this.shouldBeAberrant() ? AlienVariant.ABERRANT : this.queen.getVariant();
        EntityType<? extends Ovomorph> ovomorphType = Ovomorph.getType(variant, isRoyal);
        Ovomorph ovomorph2 = ovomorph = ovomorphType == null ? null : (Ovomorph)ovomorphType.create(level);
        if (ovomorph == null) {
            return;
        }
        ovomorph.setPos(this.queen.getOvipositorManager().getEggLayingPosition());
        ovomorph.setPersistenceRequired();
        ovomorph.isRooted.set(false);
        this.queen.getGeneManager().getGeneContainer().transfer(ovomorph.getGeneManager().getGeneContainer(), false);
        level.playSound(null, (Entity)this.queen, AVPSoundEvents.ENTITY_OVOMORPH_LAID.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        level.addFreshEntity((Entity)ovomorph);
    }

    private boolean shouldBeAberrant() {
        GeneCarrier geneCarrier = (GeneCarrier)((Object)this.queen);
        GeneDecayLevelType geneDecayLevel = GeneIntegrityUtil.getGeneDecayLevel(geneCarrier);
        return switch (geneDecayLevel) {
            default -> throw new MatchException(null, null);
            case GeneDecayLevelType.FATAL, GeneDecayLevelType.VOLATILE -> true;
            case GeneDecayLevelType.STABLE -> false;
            case GeneDecayLevelType.UNSTABLE -> {
                double totalGeneIntegrity = Math.abs(GeneIntegrityUtil.getTotalGeneticIntegrity(geneCarrier));
                double chance = totalGeneIntegrity - Math.floor(totalGeneIntegrity);
                if (this.queen.getRandom().nextDouble() < chance) {
                    yield true;
                }
                yield false;
            }
        };
    }

    private boolean noEggsNearby() {
        this.eggLayCooldownInTicks = MAX_EGG_LAY_COOLDOWN_IN_TICKS;
        return this.queen.level().getEntitiesOfClass(Ovomorph.class, this.getBoundingBoxAtEggLayingPosition(), entity -> entity.getType().is(AVPEntityTypeTags.OVOMORPHS) && entity.isRooted.get() == false).isEmpty();
    }

    private AABB getBoundingBoxAtEggLayingPosition() {
        Vec3 eggPos = this.queen.getOvipositorManager().getEggLayingPosition();
        double halfSize = 0.5;
        return new AABB(eggPos.x - halfSize, eggPos.y - (double)this.queen.level().dimensionType().height(), eggPos.z - halfSize, eggPos.x + halfSize, eggPos.y + 5.0, eggPos.z + halfSize);
    }
}

