/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.block;

import com.avp.common.registry.init.block.CoreBlocks;
import com.avp.common.registry.key.AVPBiomeKeys;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AshBlock
extends SnowLayerBlock {
    public AshBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    protected boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return levelReader.getBiome(blockPos).is(AVPBiomeKeys.NUKED_BIOME);
    }

    protected void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.nextInt(10) == 0) {
            if ((Integer)blockState.getValue((Property)LAYERS) < 8) {
                serverLevel.setBlockAndUpdate(blockPos, (BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)LAYERS) + 1)));
            } else {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos targetPos = blockPos.offset(dx, 0, dz);
                        BlockPos targetPosBelow = targetPos.below();
                        if (!serverLevel.getBlockState(targetPos).isAir() || !serverLevel.getBlockState(targetPosBelow).isSolidRender((BlockGetter)serverLevel, targetPosBelow) || serverLevel.getBlockState(targetPosBelow).is(CoreBlocks.ASH_BLOCK.get())) continue;
                        serverLevel.setBlockAndUpdate(targetPos, (BlockState)this.defaultBlockState().setValue((Property)LAYERS, (Comparable)Integer.valueOf(1)));
                        return;
                    }
                }
            }
        }
    }
}

