/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion;

import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.gameplay.explosion.ExplosionCallbacks;
import com.avp.common.gameplay.explosion.ExplosionConfig;
import com.avp.common.gameplay.explosion.ExplosionCursor;
import com.avp.server.ServerScheduler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public class ExplosionProcessor {
    private final Explosion explosion;
    private final Map<Direction, ExplosionCursor> directionToExplosionCursorMap;

    public ExplosionProcessor(Explosion explosion) {
        this.explosion = explosion;
        this.directionToExplosionCursorMap = new EnumMap(Arrays.stream(Direction.values()).collect(Collectors.toMap(Function.identity(), direction -> new ExplosionCursor(explosion, (Direction)direction))));
    }

    public void process() {
        ExplosionConfig config = this.explosion.config();
        this.processBatch(config.blockSampleCountPerCycle(), config.cycleDelayInTicks());
    }

    private void processBatch(int maxBlocksPerCycle, int delayBetweenCycles) {
        ExplosionCallbacks callbacks = this.explosion.callbacks();
        callbacks.onCycleStart();
        List<BlockPos> blocksToSample = this.sampleBlocks(maxBlocksPerCycle);
        for (BlockPos pos : blocksToSample) {
            callbacks.onBlockSample(this.explosion, pos);
        }
        callbacks.onCycleFinish(blocksToSample);
        if (this.canAnyWallMoveFurther()) {
            ServerScheduler.schedule(() -> this.processBatch(maxBlocksPerCycle, delayBetweenCycles), Duration.ofMillis((long)delayBetweenCycles * 50L));
        } else {
            callbacks.onExplosionFinish();
        }
    }

    private List<BlockPos> sampleBlocks(int maxBlocksPerCycle) {
        int count = 0;
        ArrayList<BlockPos> sampledBlocks = new ArrayList<BlockPos>();
        block0: while (count < maxBlocksPerCycle && this.canAnyWallMoveFurther()) {
            for (Map.Entry<Direction, ExplosionCursor> entry : this.directionToExplosionCursorMap.entrySet()) {
                if (count >= maxBlocksPerCycle) continue block0;
                if (!entry.getValue().canExpandFurther()) continue;
                BlockPos pos = entry.getValue().next();
                if (!this.explosion.samplerPredicate().test(this.explosion, pos)) continue;
                sampledBlocks.add(pos);
                ++count;
            }
        }
        return sampledBlocks;
    }

    private boolean canAnyWallMoveFurther() {
        return this.directionToExplosionCursorMap.values().stream().anyMatch(ExplosionCursor::canExpandFurther);
    }
}

