/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.registry.init;

import com.avp.AVPResources;
import com.avp.common.registry.AVPDeferredHolder;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.init.item.AVPItems;
import com.avp.service.Services;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AVPArmorMaterials {
    public static final AVPDeferredHolder<ArmorMaterial> MK50 = AVPArmorMaterials.register("mk50", AVPArmorMaterials.relativeDefense((Holder<ArmorMaterial>)ArmorMaterials.IRON, Map.ofEntries(Map.entry(ArmorItem.Type.CHESTPLATE, -2), Map.entry(ArmorItem.Type.LEGGINGS, -1))), 6, AVPSoundEvents.ITEM_ARMOR_EQUIP_MK50::getHolder, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AVPItems.LEAD_INGOT.get()}), 0.0f, 0.0f, true);
    public static final AVPDeferredHolder<ArmorMaterial> PRESSURE = AVPArmorMaterials.register("pressure", AVPArmorMaterials.relativeDefense((Holder<ArmorMaterial>)ArmorMaterials.IRON, Map.ofEntries(Map.entry(ArmorItem.Type.CHESTPLATE, -2), Map.entry(ArmorItem.Type.LEGGINGS, -1))), 6, AVPSoundEvents.ITEM_ARMOR_EQUIP_PRESSURE::getHolder, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AVPItems.ALUMINUM_INGOT.get()}), 0.0f, 0.0f, false);
    public static final AVPDeferredHolder<ArmorMaterial> STEEL = AVPArmorMaterials.register("steel", AVPArmorMaterials.relativeDefense((Holder<ArmorMaterial>)ArmorMaterials.IRON, Map.ofEntries(Map.entry(ArmorItem.Type.HELMET, 1), Map.entry(ArmorItem.Type.CHESTPLATE, 1), Map.entry(ArmorItem.Type.LEGGINGS, 1), Map.entry(ArmorItem.Type.BOOTS, 1))), 5, AVPSoundEvents.ITEM_ARMOR_EQUIP_STEEL::getHolder, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AVPItems.STEEL_INGOT.get()}), 0.0f, 0.0f, false);
    public static final AVPDeferredHolder<ArmorMaterial> TACTICAL = AVPArmorMaterials.register("tactical", Map.ofEntries(Map.entry(ArmorItem.Type.HELMET, 2), Map.entry(ArmorItem.Type.CHESTPLATE, 6), Map.entry(ArmorItem.Type.LEGGINGS, 3), Map.entry(ArmorItem.Type.BOOTS, 2)), 5, AVPSoundEvents.ITEM_ARMOR_EQUIP_TACTICAL::getHolder, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AVPItems.STEEL_INGOT.get()}), 0.0f, 0.0f, false);
    public static final AVPDeferredHolder<ArmorMaterial> TITANIUM = AVPArmorMaterials.register("titanium", AVPArmorMaterials.relativeDefense((Holder<ArmorMaterial>)ArmorMaterials.IRON, Map.ofEntries(Map.entry(ArmorItem.Type.HELMET, 1), Map.entry(ArmorItem.Type.CHESTPLATE, 2), Map.entry(ArmorItem.Type.LEGGINGS, 1), Map.entry(ArmorItem.Type.BOOTS, 1))), 5, AVPSoundEvents.ITEM_ARMOR_EQUIP_TITANIUM::getHolder, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)AVPItems.TITANIUM_INGOT.get()}), 1.0f, 0.0f, false);

    public static AVPDeferredHolder<ArmorMaterial> register(String id, Map<ArmorItem.Type, Integer> defensePoints, int enchantability, Supplier<Holder<SoundEvent>> equipSoundHolderSupplier, Supplier<Ingredient> repairIngredientSupplier, float toughness, float knockbackResistance, boolean dyeable) {
        ResourceLocation resourceLocation = AVPResources.location(id);
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(resourceLocation, "", dyeable));
        return Services.REGISTRY.register(BuiltInRegistries.ARMOR_MATERIAL, id, () -> new ArmorMaterial(defensePoints, enchantability, (Holder)equipSoundHolderSupplier.get(), repairIngredientSupplier, layers, toughness, knockbackResistance));
    }

    public static Map<ArmorItem.Type, Integer> relativeDefense(Holder<ArmorMaterial> armorMaterialHolder, Map<ArmorItem.Type, Integer> additiveDefense) {
        ArmorMaterial armorMaterial = (ArmorMaterial)armorMaterialHolder.value();
        return Map.ofEntries(AVPArmorMaterials.compute(ArmorItem.Type.HELMET, additiveDefense, armorMaterial), AVPArmorMaterials.compute(ArmorItem.Type.CHESTPLATE, additiveDefense, armorMaterial), AVPArmorMaterials.compute(ArmorItem.Type.LEGGINGS, additiveDefense, armorMaterial), AVPArmorMaterials.compute(ArmorItem.Type.BOOTS, additiveDefense, armorMaterial));
    }

    @NotNull
    private static Map.Entry<ArmorItem.Type, Integer> compute(ArmorItem.Type type, Map<ArmorItem.Type, Integer> additiveDefense, ArmorMaterial armorMaterial) {
        return Map.entry(type, armorMaterial.getDefense(type) + additiveDefense.getOrDefault(type, 0));
    }

    public static void initialize() {
    }
}

