/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.registry.init.block;

import com.avp.common.gameplay.block.property.BlockProperties;
import com.avp.common.gameplay.block.property.BlockPropertyBuilder;
import com.avp.common.registry.AVPDeferredHolder;
import com.avp.service.Services;
import com.human.common.gameplay.block.AmmoChestBlock;
import com.human.common.gameplay.block.IndustrialFurnaceBlock;
import com.human.common.gameplay.block.LeadChestBlock;
import com.human.common.gameplay.block.NukeBlock;
import com.human.common.gameplay.block.RazorWireBlock;
import com.human.common.gameplay.block.RedstoneGeneratorBlock;
import com.human.common.gameplay.block.SentryTurretBlock;
import com.human.common.gameplay.block.power.BatteryBlock;
import com.human.common.gameplay.block.power.CableBlock;
import com.human.common.gameplay.block.power.DeskTerminalBlock;
import com.human.common.gameplay.block.power.InfinitePowerGeneratorBlock;
import com.human.common.gameplay.block.power.ResonatorBlock;
import com.human.common.gameplay.block.power.SolarPanelBlock;
import com.human.common.gameplay.block.power.ThermalGeneratorBlock;
import com.human.common.gameplay.block.power.WindTurbineBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class AVPBlocks {
    private static final List<AVPDeferredHolder<? extends Block>> HOLDERS = new ArrayList<AVPDeferredHolder<? extends Block>>();
    public static final AVPDeferredHolder<Block> AMMO_CHEST = AVPBlocks.register("ammo_chest", () -> new AmmoChestBlock(BlockProperties.LEAD.build()));
    public static final AVPDeferredHolder<Block> BATTERY = AVPBlocks.register("battery", () -> new BatteryBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE)));
    public static final AVPDeferredHolder<Block> BLUEPRINT_BLOCK = AVPBlocks.register("blueprint_block", BlockProperties.STEEL);
    public static final AVPDeferredHolder<Block> CABLE = AVPBlocks.register("cable", () -> new CableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE).noOcclusion()));
    public static final AVPDeferredHolder<Block> DESK_TERMINAL_BLOCK = AVPBlocks.register("desk_terminal", () -> new DeskTerminalBlock(BlockProperties.STEEL.build().noOcclusion()));
    public static final AVPDeferredHolder<Block> INDUSTRIAL_FURNACE = AVPBlocks.register("industrial_furnace_block", () -> new IndustrialFurnaceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLAST_FURNACE)));
    public static final AVPDeferredHolder<Block> INFINITE_POWER_GENERATOR = AVPBlocks.register("infinite_power_generator", () -> new InfinitePowerGeneratorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE)));
    public static final AVPDeferredHolder<Block> LEAD_CHEST = AVPBlocks.register("lead_chest", () -> new LeadChestBlock(BlockProperties.LEAD.build()));
    public static final AVPDeferredHolder<Block> NUKE_BLOCK = AVPBlocks.register("nuke", () -> new NukeBlock(BlockProperties.NUKE.build()));
    public static final AVPDeferredHolder<Block> RAZOR_WIRE = AVPBlocks.register("razor_wire", () -> new RazorWireBlock(BlockProperties.RAZOR_WIRE.build()));
    public static final AVPDeferredHolder<Block> REDSTONE_GENERATOR = AVPBlocks.register("redstone_generator", () -> new RedstoneGeneratorBlock(BlockProperties.STEEL.build().randomTicks()));
    public static final AVPDeferredHolder<Block> RESONATOR_BLOCK = AVPBlocks.register("resonator", () -> new ResonatorBlock(BlockProperties.STEEL.build().noOcclusion()));
    public static final AVPDeferredHolder<Block> SENTRY_TURRET = AVPBlocks.register("sentry_turret", SentryTurretBlock::new);
    public static final AVPDeferredHolder<Block> SOLAR_PANEL = AVPBlocks.register("solar_panel", () -> new SolarPanelBlock(BlockProperties.STEEL.build().noOcclusion()));
    public static final AVPDeferredHolder<Block> THERMAL_GENERATOR = AVPBlocks.register("thermal_generator", () -> new ThermalGeneratorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE)));
    public static final AVPDeferredHolder<Block> WIND_TURBINE = AVPBlocks.register("wind_turbine", () -> new WindTurbineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE)));
    public static final Map<DyeColor, AVPDeferredHolder<Block>> DYE_COLOR_TO_CONCRETE_SLAB = Collections.unmodifiableMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), dyeColor -> AVPBlocks.register(dyeColor.getName() + "_concrete_slab", () -> new SlabBlock(BlockProperties.DYE_COLOR_TO_CONCRETE_PROPERTIES.get(dyeColor).build())))));
    public static final Map<DyeColor, AVPDeferredHolder<Block>> DYE_COLOR_TO_CONCRETE_STAIRS = Collections.unmodifiableMap(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), dyeColor -> AVPBlocks.register(dyeColor.getName() + "_concrete_stairs", () -> new StairBlock(BlockProperties.DYE_COLOR_TO_CONCRETE_BLOCKS.get(dyeColor).defaultBlockState(), BlockProperties.DYE_COLOR_TO_CONCRETE_PROPERTIES.get(dyeColor).build())))));

    public static List<AVPDeferredHolder<? extends Block>> getAll() {
        return Collections.unmodifiableList(HOLDERS);
    }

    public static AVPDeferredHolder<Block> register(String id, BlockPropertyBuilder blockPropertyBuilder) {
        return AVPBlocks.register(id, () -> new Block(blockPropertyBuilder.build()));
    }

    public static <T extends Block> AVPDeferredHolder<T> register(String id, Supplier<T> blockSupplier) {
        AVPDeferredHolder<T> holder = Services.REGISTRY.register(BuiltInRegistries.BLOCK, id, blockSupplier);
        HOLDERS.add(holder);
        return holder;
    }

    public static void initialize() {
    }
}

