/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.util;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.Host;
import com.avp.common.registry.init.AVPMobEffects;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.registry.tag.AVPItemTags;
import com.predator.common.gameplay.entity.living.yautja.Yautja;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class AVPPredicates {
    public static final Predicate<LivingEntity> IS_IMMORTAL = livingEntity -> {
        Player player;
        return livingEntity instanceof Player && ((player = (Player)livingEntity).isCreative() || player.isSpectator());
    };
    public static final Predicate<LivingEntity> HAS_FACE_MASK = livingEntity -> livingEntity.getItemBySlot(EquipmentSlot.HEAD).is(AVPItemTags.FACEHUGGER_RESISTANT_HELMETS);
    public static final Predicate<LivingEntity> HAS_MASK = livingEntity -> {
        Yautja yautja;
        return livingEntity instanceof Yautja && (yautja = (Yautja)livingEntity).hasMask();
    };

    public static <T> Predicate<T> alwaysTrue() {
        return $ -> true;
    }

    public static boolean canBeIrradiated(Entity entity) {
        LivingEntity livingEntity;
        if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).getType().is(AVPEntityTypeTags.RADIATION_RESISTANT) || IS_IMMORTAL.test(livingEntity) || livingEntity.hasEffect(AVPMobEffects.RADIATION.getHolder()) || !livingEntity.isAlive()) {
            return false;
        }
        boolean hasFullRadiationResistantArmor = AVPPredicates.hasFullArmorSetMatching(livingEntity, itemStack -> itemStack.is(AVPItemTags.RADIATION_RESISTANT_ARMORS));
        return !hasFullRadiationResistantArmor;
    }

    public static boolean hasFullArmorSetMatching(LivingEntity livingEntity, Predicate<ItemStack> itemStackPredicate) {
        return itemStackPredicate.test(livingEntity.getItemBySlot(EquipmentSlot.HEAD)) && itemStackPredicate.test(livingEntity.getItemBySlot(EquipmentSlot.CHEST)) && itemStackPredicate.test(livingEntity.getItemBySlot(EquipmentSlot.LEGS)) && itemStackPredicate.test(livingEntity.getItemBySlot(EquipmentSlot.FEET));
    }

    public static boolean hasShield(Entity target) {
        LivingEntity livingEntity;
        return target instanceof LivingEntity && (livingEntity = (LivingEntity)target).getUseItem().is(Items.SHIELD);
    }

    public static boolean hasEmbryo(Entity target) {
        Host host;
        return target instanceof Host && (host = (Host)target).getEmbryoType().isSome();
    }

    public static boolean isFreeHost(Alien parasite, Entity hostTarget) {
        return AVPPredicates.isLiving(hostTarget) && AVPPredicates.isHost(hostTarget) && !AVPPredicates.hasEmbryo(hostTarget) && !AVPPredicates.isSelfOrOtherParasiteAttached(parasite, hostTarget) && !HAS_MASK.test((LivingEntity)hostTarget) && !HAS_FACE_MASK.test((LivingEntity)hostTarget);
    }

    public static boolean isHost(Entity target) {
        return target.getType().is(AVPEntityTypeTags.HOSTS) && AVPPredicates.isLiving(target) && !AVPPredicates.isBaby(target) && !IS_IMMORTAL.test((LivingEntity)target);
    }

    public static boolean isParasiteAttached(Entity target) {
        return target.hasPassenger(passenger -> passenger.getType().is(AVPEntityTypeTags.PARASITES));
    }

    public static boolean isSelfOrOtherParasiteAttached(Alien parasite, Entity target) {
        return target.hasPassenger(passenger -> passenger.equals((Object)parasite) || passenger.getType().is(AVPEntityTypeTags.PARASITES));
    }

    public static boolean isBaby(Entity target) {
        LivingEntity livingEntity;
        return target instanceof LivingEntity && (livingEntity = (LivingEntity)target).isBaby();
    }

    public static boolean isLiving(Entity target) {
        LivingEntity livingEntity;
        return target instanceof LivingEntity && (livingEntity = (LivingEntity)target).isAlive() && !livingEntity.isDeadOrDying();
    }
}

