/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.util;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.util.AlienTransitionUtil;
import com.avp.AVP;
import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.gameplay.explosion.ExplosionProgressTracker;
import com.avp.common.gameplay.explosion.nuke.NuclearExplosionEffects;
import com.avp.common.util.AVPPredicates;
import com.human.common.gameplay.entity.nuke.MushroomCloudEntity;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ExplosionUtil {
    public static void applyKnockback(Vec3 center, double radius, Entity entity, double maxKnockback, double distance) {
        LivingEntity livingEntity;
        Vec3 direction = entity.position().subtract(center).normalize();
        double knockbackStrength = maxKnockback * (1.0 - distance / (radius * radius));
        Vec3 knockbackVelocity = direction.scale(Math.max(maxKnockback, knockbackStrength));
        if (entity instanceof LivingEntity && AVPPredicates.IS_IMMORTAL.test(livingEntity = (LivingEntity)entity)) {
            return;
        }
        entity.setDeltaMovement(knockbackVelocity);
        entity.hurtMarked = true;
    }

    public static double computeDamage(double radius, double minimumDamage, double maximumDamage, double distance) {
        double damageFactor = 1.0 - distance / radius;
        return Math.max(minimumDamage, maximumDamage * damageFactor);
    }

    public static List<Entity> getEntitiesInRadius(ServerLevel level, Vec3 center, double radius) {
        AABB boundingBox = new AABB(center.x - radius, center.y - radius, center.z - radius, center.x + radius, center.y + radius, center.z + radius);
        return level.getEntities(null, boundingBox);
    }

    public static double getNormalizedHorizontalDistance(Explosion explosion, int x, int z) {
        int radiusX = explosion.config().largestRadius(Direction.Axis.X);
        int radiusZ = explosion.config().largestRadius(Direction.Axis.Z);
        return (double)(x * x) / (double)(radiusX * radiusX) + (double)(z * z) / (double)(radiusZ * radiusZ);
    }

    public static double getNormalizedVerticalDistance(Explosion explosion, int y) {
        int radiusYDown = explosion.config().radius(Direction.DOWN);
        int radiusYUp = explosion.config().radius(Direction.UP);
        return y < 0 ? (double)(y * y) / (double)(radiusYDown * radiusYDown) : (double)(y * y) / (double)(radiusYUp * radiusYUp);
    }

    public static double getNormalizedDistance(Explosion explosion, int x, int y, int z) {
        return ExplosionUtil.getNormalizedHorizontalDistance(explosion, x, z) + ExplosionUtil.getNormalizedVerticalDistance(explosion, y);
    }

    public static Explosion createNuclearExplosion(ServerLevel level, Vec3 center, int radius, int maxKnockback) {
        ExplosionProgressTracker progressTracker = new ExplosionProgressTracker();
        NuclearExplosionEffects nuclearExplosionEffects = new NuclearExplosionEffects();
        return Explosion.builder(level, center).withRadius(Direction.Plane.HORIZONTAL, radius).withRadius(Direction.UP, radius / 2).withRadius(Direction.DOWN, 32).onExplosionStart(() -> {
            progressTracker.startTimer();
            List<Entity> entities = ExplosionUtil.getEntitiesInRadius(level, center, radius);
            for (Entity entity : entities) {
                double distance = entity.distanceToSqr(center);
                double damage = ExplosionUtil.computeDamage(radius, 5.0, 1000.0, distance);
                if (entity instanceof Alien) {
                    Alien alien = (Alien)entity;
                    AlienTransitionUtil.transitionIntoVariant(alien, AlienVariant.IRRADIATED);
                }
                entity.igniteForSeconds(15.0f);
                entity.hurt(level.damageSources().explosion(null), (float)damage);
                ExplosionUtil.applyKnockback(center, radius, entity, maxKnockback, distance);
            }
            MushroomCloudEntity mushroomCloud = new MushroomCloudEntity((Level)level, center.x(), center.y() - 23.0, center.z());
            level.addFreshEntity((Entity)mushroomCloud);
        }).onBlockSample(($, pos) -> {
            nuclearExplosionEffects.apply($, pos);
            progressTracker.incrementBlockDestroyCounter();
        }).onExplosionFinish(() -> {
            progressTracker.stopTimer();
            long timeTakenInMillis = progressTracker.timeTaken();
            long timeTakenInTicks = timeTakenInMillis / 50L;
            AVP.LOGGER.info("Explosion @ {} completed in {}ms ({} ticks), destroying {} blocks!", new Object[]{center, timeTakenInMillis, timeTakenInTicks, progressTracker.blocksDestroyed()});
        }).build();
    }
}

