/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.avp.common.registry.init.item.AVPBlockItems;
import com.avp.common.registry.tag.AVPItemTags;
import com.avp.common.util.AVPPredicates;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Inventory.class})
public class MixinInventory_InsertAmmoItemsIntoAmmoChest {
    @Shadow
    @Final
    public Player player;
    @Shadow
    @Final
    public NonNullList<ItemStack> items;

    @Inject(method={"add(ILnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAddItem(int slot, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (!stack.is(AVPItemTags.AMMO_ITEMS)) {
            return;
        }
        for (ItemStack inventoryItemStack : this.items) {
            if (!inventoryItemStack.is((Item)AVPBlockItems.AMMO_CHEST.get())) continue;
            this.insertItemIntoAmmoChest(inventoryItemStack, stack);
            if (!stack.isEmpty()) continue;
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetItem(int slot, ItemStack stack, CallbackInfo ci) {
        if (!stack.is(AVPItemTags.AMMO_ITEMS)) {
            return;
        }
        for (ItemStack inventoryItemStack : this.items) {
            if (!inventoryItemStack.is((Item)AVPBlockItems.AMMO_CHEST.get())) continue;
            this.insertItemIntoAmmoChest(inventoryItemStack, stack);
            if (!stack.isEmpty()) continue;
            ci.cancel();
        }
    }

    @Unique
    private void insertItemIntoAmmoChest(ItemStack ammoChestItemStack, ItemStack toAddItemStack) {
        Player player;
        ItemStack copyToAdd;
        Iterable oldAmmoChestItems = ((ItemContainerContents)ammoChestItemStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems();
        NonNullList newAmmoChestItems = NonNullList.create();
        int remainingToAdd = toAddItemStack.getCount();
        if (AVPPredicates.IS_IMMORTAL.test((LivingEntity)this.player)) {
            return;
        }
        for (ItemStack oldAmmoChestItem : oldAmmoChestItems) {
            int remainingToStack;
            if (oldAmmoChestItem.isStackable() && ItemStack.isSameItemSameComponents((ItemStack)oldAmmoChestItem, (ItemStack)toAddItemStack) && (remainingToStack = oldAmmoChestItem.getMaxStackSize() - oldAmmoChestItem.getCount()) > 0 && remainingToAdd > 0) {
                int toAdd = Math.min(remainingToStack, remainingToAdd);
                oldAmmoChestItem.grow(toAdd);
                remainingToAdd -= toAdd;
                toAddItemStack.shrink(toAdd);
            }
            newAmmoChestItems.add((Object)oldAmmoChestItem);
        }
        if (remainingToAdd > 0 && newAmmoChestItems.size() < 27 && newAmmoChestItems.add((Object)(copyToAdd = toAddItemStack.copyAndClear())) && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.INVENTORY_CHANGED.trigger(serverPlayer, serverPlayer.getInventory(), copyToAdd);
        }
        ammoChestItemStack.applyComponents(DataComponentPatch.builder().set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)newAmmoChestItems)).build());
    }
}

