/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.avp.common.registry.tag.AVPItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class MixinItemEntity_LithiumExplode {
    @Inject(at={@At(value="TAIL")}, method={"tick"}, cancellable=true)
    void tick(CallbackInfo callbackInfo) {
        ItemEntity self = (ItemEntity)ItemEntity.class.cast(this);
        Level level = self.level();
        if (!self.getItem().is(AVPItemTags.LITHIUM)) {
            return;
        }
        if (level.isClientSide || level.getGameTime() % 10L != 0L) {
            return;
        }
        if (self.isInWater()) {
            this.explode(level, (Entity)self);
            self.kill();
            return;
        }
        if (self.onGround() && this.canExplodeAtEntityPosition(level, (Entity)self)) {
            this.explode(level, (Entity)self);
            self.kill();
        }
    }

    @Unique
    private boolean canExplodeAtEntityPosition(Level level, Entity entity) {
        if (level.random.nextInt(25) != 0) {
            return false;
        }
        return level.isRainingAt(entity.blockPosition()) && level.canSeeSky(entity.blockPosition());
    }

    @Unique
    private void explode(Level level, Entity entity) {
        level.explode(entity, entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 1.0f, Level.ExplosionInteraction.NONE);
    }
}

