/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.alien.common.data.AlienAdvancements;
import com.alien.common.model.alien.Host;
import com.alien.common.util.AlienEmbryoUtil;
import com.avp.common.util.AVPPredicates;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ChorusFruitItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChorusFruitItem.class})
public class MixinItem_ChorusEmbryo {
    @Inject(method={"finishUsingItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void removeEmbryo(ItemStack stack, Level level, LivingEntity livingEntity, CallbackInfoReturnable<ItemStack> cir) {
        Host host;
        block7: {
            block6: {
                if (!(livingEntity instanceof Host)) break block6;
                host = (Host)livingEntity;
                if (!level.isClientSide() && AVPPredicates.hasEmbryo((Entity)livingEntity)) break block7;
            }
            return;
        }
        List<Entity> embryos = AlienEmbryoUtil.birthEmbryos(livingEntity);
        embryos.forEach(embryo -> {
            if (embryo instanceof LivingEntity) {
                LivingEntity livingEmbryo = (LivingEntity)embryo;
                livingEmbryo.setPos(livingEntity.position());
                MixinItem_ChorusEmbryo.tryTeleportingEntity(livingEmbryo);
                ((GeneCarrier)livingEmbryo).getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().add(Genes.WARP, GeneOperationType.ADDITIVE, 1.0);
            }
        });
        if (!embryos.isEmpty()) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.resetCurrentImpulseContext();
                player.getCooldowns().addCooldown(stack.getItem(), 20);
            }
            host.removeEmbryo();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                AlienAdvancements.REMOVE_EMBRYO_WITH_CHORUS_FRUIT.grant(serverPlayer);
            }
            cir.setReturnValue((Object)stack);
        }
    }

    @Unique
    private static void tryTeleportingEntity(LivingEntity livingEntity) {
        Level level = livingEntity.level();
        if (level.isClientSide) {
            return;
        }
        if (livingEntity.isPassenger()) {
            livingEntity.stopRiding();
        }
        Vec3 entityPos = livingEntity.position();
        for (int i = 0; i < 16; ++i) {
            double zOffset;
            double yOffset;
            double xOffset = livingEntity.getX() + (livingEntity.getRandom().nextDouble() - 0.5) * 16.0;
            if (!livingEntity.randomTeleport(xOffset, yOffset = Mth.clamp((double)(livingEntity.getY() + (double)(livingEntity.getRandom().nextInt(16) - 8)), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + ((ServerLevel)level).getLogicalHeight() - 1)), zOffset = livingEntity.getZ() + (livingEntity.getRandom().nextDouble() - 0.5) * 16.0, true)) continue;
            level.gameEvent((Holder)GameEvent.TELEPORT, entityPos, GameEvent.Context.of((Entity)livingEntity));
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.PLAYERS);
            livingEntity.resetFallDistance();
        }
    }
}

