/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.alien.common.util.AcidBleedUtil;
import com.avp.common.registry.init.AVPDataKeys;
import com.lib.common.gameplay.entity.manager.GeneManager;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import com.lib.common.network.DataAccessor;
import com.lib.common.network.DataUser;
import com.lib.common.util.GeneResistanceHurtUtil;
import com.lib.common.util.TeleportUtil;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity_GeneCarrier
extends Entity
implements GeneCarrier,
DataUser {
    @Unique
    private final DataAccessor<Boolean> avp$hasWarpEffect = new DataAccessor<Boolean>(this, AVPDataKeys.ENTITY_HAS_WARP_EFFECT);
    @Unique
    private GeneManager avp$geneManager;

    public MixinLivingEntity_GeneCarrier(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo callbackInfo) {
        GeneManager geneManager = this.getOrCreateGeneManager();
        geneManager.tick();
        if (this.level().isClientSide && this.avp$hasWarpEffect.get().booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        if (!this.level().isClientSide) {
            this.avp$hasWarpEffect.set(this.avp$hasWarpGene());
        }
    }

    @ModifyVariable(method={"hurt"}, at=@At(value="HEAD"), index=2, argsOnly=true)
    private float avp$hurt(float originalDamage, DamageSource damageSource) {
        return GeneResistanceHurtUtil.applyResistancesToDamage(this, damageSource, originalDamage);
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    public void avp$hurt(DamageSource damageSource, float damage, CallbackInfoReturnable<Boolean> cir) {
        if (damage == 0.0f) {
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    public void avp$preHurtEffects(DamageSource damageSource, float damage, CallbackInfoReturnable<Boolean> cir) {
        if (this.avp$hasWarpEffect.get().booleanValue() && (damageSource.is(DamageTypeTags.IS_PROJECTILE) || this.random.nextInt(10) == 0)) {
            LivingEntity self = (LivingEntity)LivingEntity.class.cast(this);
            for (int i = 0; i < 64; ++i) {
                if (!TeleportUtil.teleport(self)) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"hurt"})
    public void avp$postHurtEffects(DamageSource damageSource, float damage, CallbackInfoReturnable<Boolean> cir) {
        boolean isHurt = cir.getReturnValueZ();
        if (isHurt) {
            this.avp$handleAcidBloodGene(damageSource, damage);
            this.avp$handlePoisonousBarbsGene(damageSource, damage);
            this.avp$handleThornsGene(damageSource, damage);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"isSensitiveToWater"}, cancellable=true)
    public void avp$isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        boolean isSensitiveToWater = cir.getReturnValueZ();
        cir.setReturnValue((Object)(isSensitiveToWater || this.avp$hasWarpGene() ? 1 : 0));
    }

    @Unique
    private boolean avp$hasWarpGene() {
        return this.getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().hasGene(Genes.WARP);
    }

    @Unique
    private void avp$handleAcidBloodGene(DamageSource damageSource, float damage) {
        double acidBloodChance = this.getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().getValue(Genes.ACIDIC_BLOOD, GeneOperationType.MULTIPLICATIVE);
        if (this.getRandom().nextDouble() < acidBloodChance && damageSource != this.damageSources().genericKill()) {
            LivingEntity self = (LivingEntity)LivingEntity.class.cast(this);
            Vec3 randomPos = AcidBleedUtil.computeRandomPosFromBoundingBox(self);
            AcidBleedUtil.spawnAcid(self, damage, randomPos);
        }
    }

    @Unique
    private void avp$handlePoisonousBarbsGene(DamageSource damageSource, float damage) {
        Entity entity;
        if (!damageSource.is(DamageTypeTags.AVOIDS_GUARDIAN_THORNS) && (entity = damageSource.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            double poisonChance = this.getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().getValue(Genes.POISONOUS_BARBS, GeneOperationType.MULTIPLICATIVE);
            if (this.getRandom().nextDouble() < poisonChance) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 120, 0), (Entity)this);
            }
        }
    }

    @Unique
    private void avp$handleThornsGene(DamageSource damageSource, float damage) {
        Entity entity;
        if (!damageSource.is(DamageTypeTags.AVOIDS_GUARDIAN_THORNS) && (entity = damageSource.getDirectEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            double thornsDamage = this.getOrCreateGeneManager().getGeneContainer().getActiveGeneMap().getValue(Genes.THORNS, GeneOperationType.ADDITIVE);
            if (thornsDamage >= 0.0) {
                livingEntity.hurt(livingEntity.damageSources().thorns((Entity)this), (float)thornsDamage);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo callbackInfo) {
        this.getOrCreateGeneManager().load(compoundTag);
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo callbackInfo) {
        this.getOrCreateGeneManager().save(compoundTag);
    }

    @Override
    public GeneManager getOrCreateGeneManager() {
        if (this.avp$geneManager == null) {
            LivingEntity self = (LivingEntity)LivingEntity.class.cast(this);
            this.avp$geneManager = new GeneManager(self);
        }
        return this.avp$geneManager;
    }

    @Override
    public void setGeneManager(GeneManager geneManager) {
        this.avp$geneManager = geneManager;
    }
}

