/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin.client;

import com.avp.common.util.AVPPredicates;
import com.human.common.gameplay.item.GunItem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class MixinGui_CrosshairPickEntityWithinGunRange {
    @Inject(method={"renderCrosshair"}, at={@At(value="HEAD")})
    private void modifyAttackIndicator(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.getMainHandItem();
        Item item = itemStack.getItem();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gun = (GunItem)item;
        HitResult hitResult = ProjectileUtil.getHitResultOnViewVector((Entity)player, entity -> entity.getType() == EntityType.END_CRYSTAL || AVPPredicates.isLiving(entity), (double)gun.getGunConfig().getDefaultFireMode().range());
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Minecraft.getInstance().crosshairPickEntity = entityHitResult.getEntity();
        }
    }
}

