/*
 * Decompiled with CFR 0.152.
 */
package com.avp.neoforge;

import com.avp.AVP;
import com.avp.common.AVPEvents;
import com.avp.common.data.worldgen.AVPVillageInjection;
import com.avp.common.model.spawning.AVPEntitySpawnPlacementData;
import com.avp.common.network.NetworkHandler;
import com.avp.common.registry.init.AVPVillagerProfessions;
import com.avp.common.registry.key.AVPVillagerGiftKeys;
import com.avp.mixin.GiveGiftToHeroAccessor;
import com.avp.mixin.ParrotSoundMapAccessor;
import com.avp.neoforge.service.NeoForgeRegistryService;
import com.avp.service.Services;
import com.lib.common.network.DataContainer;
import com.lib.common.network.DataUser;
import com.lib.common.util.codec.stream.adapter.JustStreamCodecToMojangStreamCodecAdapter;
import com.predator.common.registry.init.PredatorEntityTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.cache.AzIdentityRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.DirectionalPayloadHandler;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="avp")
public class AVPNeoForge {
    private static final NeoForgeRegistryService REGISTRY = (NeoForgeRegistryService)Services.REGISTRY;

    public AVPNeoForge(IEventBus modBus) {
        AVP.initialize();
        REGISTRY.initialize(modBus);
        modBus.addListener(AVPNeoForge::registerPayloadHandlers);
        modBus.addListener(AVPNeoForge::registerEntityAttributes);
        modBus.addListener(AVPNeoForge::registerSpawnPlacements);
        modBus.addListener(AVPNeoForge::registerMiscellaneous);
        NeoForge.EVENT_BUS.addListener(AVPNeoForge::registerCommands);
        NeoForge.EVENT_BUS.addListener(AVPNeoForge::registerDataReloadListeners);
        NeoForge.EVENT_BUS.addListener(AVPNeoForge::registerPlayerTrackingEntityHandler);
        NeoForge.EVENT_BUS.addListener(AVPNeoForge::registerTagUpdateHandler);
        NeoForge.EVENT_BUS.addListener(AVPNeoForge::addNewVillageBuilding);
        NeoForge.EVENT_BUS.addListener(AVPNeoForge::addCustomTrades);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, AVPNeoForge::onWorldEndTick);
    }

    public static void registerMiscellaneous(FMLCommonSetupEvent event) {
        REGISTRY.getAzureLibItemIdentitySuppliers().forEach(itemSupplier -> AzIdentityRegistry.register((Item)((Item)itemSupplier.get()), (Item[])new Item[0]));
    }

    public static void registerCommands(RegisterCommandsEvent event) {
        REGISTRY.getLiteralArgumentBuilders().forEach(literalArgumentBuilder -> event.getDispatcher().register(literalArgumentBuilder));
    }

    public static void registerDataReloadListeners(AddReloadListenerEvent event) {
        REGISTRY.getReloadListeners().forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }

    public static void registerPlayerTrackingEntityHandler(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ((DataUser)livingEntity).getDataContainer().syncToClient((Entity)livingEntity, DataContainer.SyncType.ALL);
        }
    }

    public static void registerTagUpdateHandler(TagsUpdatedEvent event) {
        AVPEvents.onTagsUpdated();
    }

    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        REGISTRY.getEntityAttributeSupplierPairs().forEach(pair -> event.put((EntityType)((Supplier)pair.v1()).get(), ((AttributeSupplier.Builder)((Supplier)pair.v2()).get()).build()));
    }

    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        REGISTRY.getEntitySpawnDataEntries().forEach(spawnData -> {
            if (spawnData.isPlacementDisabled()) {
                return;
            }
            EntityType entityType = spawnData.getEntityType();
            AVPEntitySpawnPlacementData placementData = spawnData.getPlacementData();
            SpawnPlacementType placement = placementData.type();
            Heightmap.Types heightMap = placementData.heightmapType();
            SpawnPlacements.SpawnPredicate spawnPredicate = placementData.spawnPredicate();
            event.register(entityType, placement, heightMap, spawnPredicate, RegisterSpawnPlacementsEvent.Operation.AND);
        });
    }

    public static void addNewVillageBuilding(ServerAboutToStartEvent event) {
        Registry templatePoolRegistry = (Registry)event.getServer().registryAccess().registry(Registries.TEMPLATE_POOL).orElseThrow();
        Registry processorListRegistry = (Registry)event.getServer().registryAccess().registry(Registries.PROCESSOR_LIST).orElseThrow();
        AVPVillageInjection.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/plains/houses"), "avp:village/plains/houses/plains_commissary", 5);
        AVPVillageInjection.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/snowy/houses"), "avp:village/snowy/houses/snowy_commissary", 5);
        AVPVillageInjection.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/savanna/houses"), "avp:village/savanna/houses/savanna_commissary", 5);
        AVPVillageInjection.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/taiga/houses"), "avp:village/taiga/houses/taiga_commissary", 5);
        AVPVillageInjection.addBuildingToPool((Registry<StructureTemplatePool>)templatePoolRegistry, (Registry<StructureProcessorList>)processorListRegistry, ResourceLocation.withDefaultNamespace((String)"village/desert/houses"), "avp:village/desert/houses/desert_commissary", 5);
    }

    public static void onWorldEndTick(LevelTickEvent.Post event) {
        if (event.getLevel().isClientSide) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)event.getLevel();
        Map<EntityType<?>, SoundEvent> sounds = ParrotSoundMapAccessor.getSoundMap();
        Map<VillagerProfession, ResourceKey<LootTable>> gifts = GiveGiftToHeroAccessor.getGifts();
        AVP.CUSTOM_SPAWNER.tick(serverLevel, serverLevel.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING), true);
        AVP.NUKED_ASH_PLACEMENT.tick(serverLevel);
        sounds.put(PredatorEntityTypes.YAUTJA.get(), SoundEvents.ALLAY_AMBIENT_WITH_ITEM);
        gifts.put(AVPVillagerProfessions.COMMISSARY.get(), AVPVillagerGiftKeys.COMMISSARY_GIFT_LOOT_TABLE);
    }

    public static void addCustomTrades(VillagerTradesEvent event) {
        Int2ObjectMap trades = event.getTrades();
        REGISTRY.getVillagerTradeData().forEach(villagerTradeData -> {
            if (event.getType() == ((Supplier)villagerTradeData.v1()).get()) {
                ((List)trades.get(villagerTradeData.v2())).addAll((Collection)villagerTradeData.v3());
            }
        });
    }

    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1").executesOn(HandlerThread.NETWORK);
        REGISTRY.getNetworkHandlers().forEach(networkHandler -> {
            NetworkHandler typedNetworkHandler;
            NetworkHandler networkHandler2 = typedNetworkHandler = networkHandler;
            Objects.requireNonNull(networkHandler2);
            NetworkHandler selector0$temp = networkHandler2;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NetworkHandler.FromClient.class, NetworkHandler.FromEither.class, NetworkHandler.FromServer.class}, (Object)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    NetworkHandler.FromClient handler = (NetworkHandler.FromClient)selector0$temp;
                    registrar.playToServer(handler.type(), new JustStreamCodecToMojangStreamCodecAdapter(handler.codec()), (payload, context) -> context.enqueueWork(() -> handler.payloadConsumer().accept(payload, context.player())));
                    break;
                }
                case 1: {
                    NetworkHandler.FromEither handler = (NetworkHandler.FromEither)selector0$temp;
                    registrar.playBidirectional(handler.type(), new JustStreamCodecToMojangStreamCodecAdapter(handler.codec()), (IPayloadHandler)new DirectionalPayloadHandler((payload, context) -> context.enqueueWork(() -> handler.fromServerPayloadConsumer().accept(payload, context.player())), (payload, context) -> context.enqueueWork(() -> handler.fromClientPayloadConsumer().accept(payload, context.player()))));
                    break;
                }
                case 2: {
                    NetworkHandler.FromServer handler = (NetworkHandler.FromServer)selector0$temp;
                    registrar.playToClient(handler.type(), new JustStreamCodecToMojangStreamCodecAdapter(handler.codec()), (payload, context) -> context.enqueueWork(() -> handler.payloadConsumer().accept(payload, context.player())));
                }
            }
        });
    }
}

