/*
 * Decompiled with CFR 0.152.
 */
package com.avp.server;

import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.avp.server.BlockBreakProgressManager;
import com.avp.server.ServerScheduler;
import com.human.common.gameplay.power.PowerSystem;
import com.lib.common.data.Cooldown;
import java.time.Duration;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class ServerLevelManager {
    private final Cooldown queenSpawnCooldown = Cooldown.withCooldownTime("queenSpawnCooldownInTicks", Duration.ofMinutes(5L));

    public ServerLevelManager() {
        this.queenSpawnCooldown.reset();
    }

    public void tick(ServerLevel serverLevel) {
        this.tickScheduledRunnables();
        this.queenSpawnCooldown.tick();
        HiveLevelData.getOrCreate((Level)serverLevel).ifSome(HiveLevelData::tick);
        BlockBreakProgressManager.tick((Level)serverLevel);
        PowerSystem.get(serverLevel).tick();
    }

    private void tickScheduledRunnables() {
        ServerScheduler.getScheduledTasks().removeIf(entry -> {
            Long runTime = (Long)entry.getKey();
            if (System.currentTimeMillis() >= runTime) {
                ((Runnable)entry.getValue()).run();
                return true;
            }
            return false;
        });
    }

    public Cooldown getQueenSpawnCooldown() {
        return this.queenSpawnCooldown;
    }
}

