/*
 * Decompiled with CFR 0.152.
 */
package com.compat.gigeresque.common.patch;

import com.alien.common.model.alien.Host;
import com.alien.common.util.AlienEmbryoUtil;
import com.avp.common.util.AVPPredicates;
import com.compat.gigeresque.GigResources;
import java.util.List;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.item.GigItems;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GigSurgeryKitPatch {
    public static void removeParasite(Player player, LivingEntity livingEntity, ItemStack itemStack) {
        Host host;
        block5: {
            block4: {
                if (!(livingEntity instanceof Host)) break block4;
                host = (Host)livingEntity;
                if (!player.level().isClientSide() && AVPPredicates.hasEmbryo((Entity)livingEntity) && itemStack.is((Item)GigItems.SURGERY_KIT.get())) break block5;
            }
            return;
        }
        List<Entity> embryos = AlienEmbryoUtil.birthEmbryos(livingEntity);
        if (!embryos.isEmpty()) {
            host.removeEmbryo();
            GigSurgeryKitPatch.applySurgeryKitBehavior(player, livingEntity, itemStack);
        }
    }

    private static void applySurgeryKitBehavior(Player player, LivingEntity livingEntity, ItemStack itemStack) {
        player.getCooldowns().addCooldown(itemStack.getItem(), CommonMod.config.surgeryKitCooldownTicks);
        if (!player.isCreative() || !player.isSpectator()) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, livingEntity.getEquipmentSlotForItem(itemStack));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(GigResources.location("surgery_kit"));
            if (advancement != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                for (String s : serverPlayer.getAdvancements().getOrStartProgress(advancement).getRemainingCriteria()) {
                    serverPlayer.getAdvancements().award(advancement, s);
                }
            }
        }
    }
}

