/*
 * Decompiled with CFR 0.152.
 */
package com.human.client.animation.entity;

import com.avp.AVPResources;
import com.avp.client.animation.BasicAnimationUtils;
import com.human.common.gameplay.entity.living.human.marine.Marine;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.animation.cache.AzBoneCache;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationController;
import mod.azure.azurelib.rewrite.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class MarineAnimator
extends AzEntityAnimator<Marine> {
    private static final String NAME = "marine";
    private static final ResourceLocation ANIMATION = AVPResources.entityAnimationLocation("marine");

    public void registerControllers(AzAnimationControllerContainer<Marine> animationControllerContainer) {
        animationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"full_body").setTransitionLength(5).build(), new AzAnimationController[0]);
    }

    @NotNull
    public ResourceLocation getAnimationLocation(Marine animatable) {
        return ANIMATION;
    }

    public void setCustomAnimations(Marine animatable, float partialTicks) {
        super.setCustomAnimations((Object)animatable, partialTicks);
        BasicAnimationUtils.applyHeadRotations((LivingEntity)animatable, this.context(), partialTicks, "gHead", 0.0f);
        AzBoneCache boneCache = this.context().boneCache();
        AzBone leftArm = boneCache.getBakedModel().getBoneOrNull("gLeftArm");
        AzBone rightArm = boneCache.getBakedModel().getBoneOrNull("gRightArm");
        AzBone leftLeg = boneCache.getBakedModel().getBoneOrNull("gLeftLeg");
        AzBone rightLeg = boneCache.getBakedModel().getBoneOrNull("gRightLeg");
        if (leftArm != null && !animatable.isAggressive()) {
            leftArm.setRotX(Mth.cos((float)(animatable.walkAnimation.position(partialTicks) * 0.6662f)) * 1.0f * animatable.walkAnimation.speed() * 0.9f);
        }
        if (rightArm != null && !animatable.isAggressive()) {
            rightArm.setRotX(Mth.cos((float)(animatable.walkAnimation.position(partialTicks) * 0.6662f + (float)Math.PI)) * 1.0f * animatable.walkAnimation.speed() * 0.9f);
        }
        if (leftLeg != null) {
            leftLeg.setRotX(Mth.cos((float)(animatable.walkAnimation.position(partialTicks) * 0.6662f + (float)Math.PI)) * 1.4f * animatable.walkAnimation.speed() * 0.9f);
        }
        if (rightLeg != null) {
            rightLeg.setRotX(Mth.cos((float)(animatable.walkAnimation.position(partialTicks) * 0.6662f)) * 1.4f * animatable.walkAnimation.speed() * 0.9f);
        }
    }
}

