/*
 * Decompiled with CFR 0.152.
 */
package com.human.client.render.entity;

import com.avp.AVPResources;
import com.human.client.render.layer.human.HumanArmorLayer;
import com.human.client.render.layer.human.HumanBeardLayer;
import com.human.client.render.layer.human.HumanEyesLayer;
import com.human.client.render.layer.human.HumanHairLayer;
import com.human.client.render.layer.human.HumanItemLayer;
import com.human.client.render.layer.human.HumanSkinLayer;
import com.human.common.gameplay.entity.living.human.AbstractHuman;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractHumanRenderer<T extends AbstractHuman>
extends AzEntityRenderer<T> {
    private static final String NAME = "marine";
    private static final ResourceLocation MALE_MODEL = AVPResources.entityGeoModelLocation("marine_male");
    private static final ResourceLocation FEMALE_MODEL = AVPResources.entityGeoModelLocation("marine_female");
    private static final ResourceLocation TEXTURE = AVPResources.entityTextureLocation("human/base");

    public static <T extends AbstractHuman> ResourceLocation getModel(T entity) {
        return entity.isMale.get() != false ? MALE_MODEL : FEMALE_MODEL;
    }

    public static <T extends AbstractHuman> ResourceLocation getTexture(T entity) {
        return TEXTURE;
    }

    public AbstractHumanRenderer(EntityRendererProvider.Context context) {
        this(AbstractHumanRenderer.createConfig(), context);
    }

    public AbstractHumanRenderer(AzEntityRendererConfig.Builder<T> builder, EntityRendererProvider.Context context) {
        super(builder.build(), context);
    }

    protected static <T extends AbstractHuman> AzEntityRendererConfig.Builder<T> createConfig() {
        return AzEntityRendererConfig.builder(AbstractHumanRenderer::getModel, AbstractHumanRenderer::getTexture).addRenderLayer(new HumanArmorLayer()).addRenderLayer(new HumanHairLayer()).addRenderLayer(new HumanEyesLayer()).addRenderLayer(new HumanSkinLayer()).addRenderLayer(new HumanBeardLayer()).addRenderLayer(new HumanItemLayer());
    }
}

