/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block;

import com.human.common.gameplay.entity.nuke.PrimedNuke;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class NukeBlock
extends Block {
    public static final MapCodec<NukeBlock> CODEC = NukeBlock.simpleCodec(NukeBlock::new);
    public static final BooleanProperty UNSTABLE = BlockStateProperties.UNSTABLE;

    public NukeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends NukeBlock> codec() {
        return CODEC;
    }

    public boolean dropFromExplosion(@NotNull Explosion explosion) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UNSTABLE});
    }

    protected void neighborChanged(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Block block, @NotNull BlockPos blockPos2, boolean bl) {
        if (level.hasNeighborSignal(blockPos)) {
            this.summonNuke(level, blockPos);
        }
    }

    protected void onPlace(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState2.is(blockState.getBlock()) && level.hasNeighborSignal(blockPos)) {
            this.summonNuke(level, blockPos);
        }
    }

    @NotNull
    public BlockState playerWillDestroy(Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Player player) {
        if (!level.isClientSide() && !player.isCreative() && ((Boolean)blockState.getValue((Property)UNSTABLE)).booleanValue()) {
            this.summonNuke(level, blockPos);
        }
        return super.playerWillDestroy(level, blockPos, blockState, player);
    }

    protected void onProjectileHit(Level level, @NotNull BlockState blockState, @NotNull BlockHitResult blockHitResult, @NotNull Projectile projectile) {
        if (!level.isClientSide) {
            BlockPos blockPos = blockHitResult.getBlockPos();
            if (projectile.isOnFire() && projectile.mayInteract(level, blockPos)) {
                this.summonNuke(level, blockPos);
            } else if (projectile.mayInteract(level, blockPos)) {
                blockState.setValue((Property)UNSTABLE, (Comparable)Boolean.valueOf(true));
            }
        }
    }

    private void summonNuke(Level level, BlockPos blockPos) {
        PrimedNuke nuke = new PrimedNuke(level);
        nuke.setPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
        nuke.setFuse(300);
        level.addFreshEntity((Entity)nuke);
        level.removeBlock(blockPos, false);
    }
}

