/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity;

import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.avp.common.registry.init.block.AVPBlocks;
import com.avp.common.registry.init.item.AVPItems;
import com.avp.common.registry.tag.AVPItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class AmmoChestBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private final ChestLidController chestLidController = new ChestLidController();
    private final ContainerOpenersCounter openersCounter;
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);

    public AmmoChestBlockEntity(BlockPos pos, BlockState blockState) {
        super(AVPBlockEntityTypes.AMMO_CHEST.get(), pos, blockState);
        this.openersCounter = new ContainerOpenersCounter(){

            protected void onOpen(Level level, BlockPos pos, BlockState state) {
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            }

            protected void onClose(Level level, BlockPos pos, BlockState state) {
                level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            }

            protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int count, int openCount) {
                level.blockEvent(AmmoChestBlockEntity.this.worldPosition, AVPBlocks.AMMO_CHEST.get(), 1, openCount);
            }

            protected boolean isOwnContainer(Player player) {
                if (!(player.containerMenu instanceof ChestMenu)) {
                    return false;
                }
                Container container = ((ChestMenu)player.containerMenu).getContainer();
                return container == AmmoChestBlockEntity.this;
            }
        };
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.itemStacks, (HolderLookup.Provider)registries);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.itemStacks, (HolderLookup.Provider)registries);
        }
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, AmmoChestBlockEntity blockEntity) {
        blockEntity.chestLidController.tickLid();
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"container.ammo_chest");
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.itemStacks;
    }

    protected void setItems(NonNullList<ItemStack> items) {
        this.itemStacks = items;
    }

    public void setItem(int slot, ItemStack stack) {
        if (this.isValidForChest(stack)) {
            super.setItem(slot, stack);
            this.setChanged();
        } else if (!stack.isEmpty() && this.level != null) {
            this.dropItem(stack);
        }
    }

    private void dropItem(ItemStack stack) {
        if (this.level != null && !this.level.isClientSide) {
            this.level.addFreshEntity((Entity)new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack));
        }
    }

    private boolean isValidForChest(ItemStack stack) {
        return stack.isEmpty() || stack.is(AVPItemTags.AMMO_ITEMS);
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return ChestMenu.threeRows((int)containerId, (Inventory)inventory, (Container)this);
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }

    public boolean hasAmmo() {
        return !this.itemStacks.isEmpty() && this.itemStacks.stream().anyMatch(item -> item.is(AVPItems.MEDIUM_BULLET.get()));
    }

    public boolean consumeAmmo(int count) {
        for (ItemStack itemStack : this.itemStacks) {
            int available;
            if (!itemStack.is(AVPItems.MEDIUM_BULLET.get()) || (available = itemStack.getCount()) < count) continue;
            itemStack.shrink(count);
            this.setChanged();
            return true;
        }
        return false;
    }
}

