/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity;

import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.avp.common.registry.init.AVPRecipes;
import com.avp.mixin.AbstractFurnaceBlockEntityInvoker;
import com.human.common.gameplay.menu.IndustrialFurnaceMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class IndustrialFurnaceBlockEntity
extends AbstractFurnaceBlockEntity {
    public IndustrialFurnaceBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(AVPBlockEntityTypes.INDUSTRIAL_FURNACE.get(), blockPos, blockState, AVPRecipes.INDUSTRIAL_FURNACE_RECIPE_TYPE.get());
    }

    public int getBurnDuration(@NotNull ItemStack itemStack) {
        return super.getBurnDuration(itemStack) / 4;
    }

    public static int getTotalCookTime(Level level, AbstractFurnaceBlockEntity abstractFurnaceBlockEntity) {
        SingleRecipeInput singleRecipeInput = new SingleRecipeInput(abstractFurnaceBlockEntity.getItem(0));
        return abstractFurnaceBlockEntity.quickCheck.getRecipeFor((RecipeInput)singleRecipeInput, level).map(recipeHolder -> ((AbstractCookingRecipe)recipeHolder.value()).getCookingTime() / 2).orElse(200);
    }

    public void setItem(int i, ItemStack itemStack) {
        ItemStack itemStack2 = (ItemStack)this.items.get(i);
        boolean bl = !itemStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack2, (ItemStack)itemStack);
        this.items.set(i, (Object)itemStack);
        itemStack.limitSize(this.getMaxStackSize(itemStack));
        if (i == 0 && !bl) {
            this.cookingTotalTime = IndustrialFurnaceBlockEntity.getTotalCookTime(this.level, this);
            this.cookingProgress = 0;
            this.setChanged();
        }
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState blockState, AbstractFurnaceBlockEntity abstractFurnaceBlockEntity) {
        boolean bl4;
        boolean bl = abstractFurnaceBlockEntity.isLit();
        boolean bl2 = false;
        if (abstractFurnaceBlockEntity.isLit()) {
            --abstractFurnaceBlockEntity.litTime;
        }
        ItemStack itemStack = (ItemStack)abstractFurnaceBlockEntity.items.get(1);
        ItemStack itemStack2 = (ItemStack)abstractFurnaceBlockEntity.items.get(0);
        boolean bl3 = !itemStack2.isEmpty();
        boolean bl5 = bl4 = !itemStack.isEmpty();
        if (abstractFurnaceBlockEntity.isLit() || bl4 && bl3) {
            RecipeHolder recipeHolder = bl3 ? (RecipeHolder)abstractFurnaceBlockEntity.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(itemStack2), level).orElse(null) : null;
            int i = abstractFurnaceBlockEntity.getMaxStackSize();
            if (!abstractFurnaceBlockEntity.isLit() && IndustrialFurnaceBlockEntity.canBurn(level.registryAccess(), recipeHolder, (NonNullList<ItemStack>)abstractFurnaceBlockEntity.items, i)) {
                abstractFurnaceBlockEntity.litDuration = abstractFurnaceBlockEntity.litTime = ((AbstractFurnaceBlockEntityInvoker)abstractFurnaceBlockEntity).invokeGetBurnDuration(itemStack);
                if (abstractFurnaceBlockEntity.isLit()) {
                    bl2 = true;
                    if (bl4) {
                        Item item = itemStack.getItem();
                        itemStack.shrink(1);
                        if (itemStack.isEmpty()) {
                            Item item2 = item.getCraftingRemainingItem();
                            abstractFurnaceBlockEntity.items.set(1, (Object)(item2 == null ? ItemStack.EMPTY : new ItemStack((ItemLike)item2)));
                        }
                    }
                }
            }
            if (abstractFurnaceBlockEntity.isLit() && IndustrialFurnaceBlockEntity.canBurn(level.registryAccess(), recipeHolder, (NonNullList<ItemStack>)abstractFurnaceBlockEntity.items, i)) {
                ++abstractFurnaceBlockEntity.cookingProgress;
                if (abstractFurnaceBlockEntity.cookingProgress == abstractFurnaceBlockEntity.cookingTotalTime) {
                    abstractFurnaceBlockEntity.cookingProgress = 0;
                    abstractFurnaceBlockEntity.cookingTotalTime = IndustrialFurnaceBlockEntity.getTotalCookTime(level, abstractFurnaceBlockEntity);
                    if (IndustrialFurnaceBlockEntity.burn(level.registryAccess(), recipeHolder, (NonNullList<ItemStack>)abstractFurnaceBlockEntity.items, i)) {
                        abstractFurnaceBlockEntity.setRecipeUsed(recipeHolder);
                    }
                    bl2 = true;
                }
            } else {
                abstractFurnaceBlockEntity.cookingProgress = 0;
            }
        } else if (!abstractFurnaceBlockEntity.isLit() && abstractFurnaceBlockEntity.cookingProgress > 0) {
            abstractFurnaceBlockEntity.cookingProgress = Mth.clamp((int)(abstractFurnaceBlockEntity.cookingProgress - 2), (int)0, (int)abstractFurnaceBlockEntity.cookingTotalTime);
        }
        if (bl != abstractFurnaceBlockEntity.isLit()) {
            bl2 = true;
            blockState = (BlockState)blockState.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(abstractFurnaceBlockEntity.isLit()));
            level.setBlock(blockPos, blockState, 3);
        }
        if (bl2) {
            IndustrialFurnaceBlockEntity.setChanged((Level)level, (BlockPos)blockPos, (BlockState)blockState);
        }
    }

    public static boolean burn(@NotNull RegistryAccess registryAccess, RecipeHolder<?> recipe, @NotNull NonNullList<ItemStack> inventory, int maxStackSize) {
        if (recipe != null && IndustrialFurnaceBlockEntity.canBurn(registryAccess, recipe, inventory, maxStackSize)) {
            ItemStack itemstack = (ItemStack)inventory.get(0);
            ItemStack itemstack1 = recipe.value().getResultItem((HolderLookup.Provider)registryAccess);
            ItemStack itemstack2 = (ItemStack)inventory.get(2);
            if (itemstack2.isEmpty()) {
                inventory.set(2, (Object)itemstack1.copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack2, (ItemStack)itemstack1)) {
                itemstack2.grow(1);
            }
            if (itemstack.is(Blocks.WET_SPONGE.asItem()) && !((ItemStack)inventory.get(1)).isEmpty() && ((ItemStack)inventory.get(1)).is(Items.BUCKET)) {
                inventory.set(1, (Object)new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    public static boolean canBurn(@NotNull RegistryAccess registryAccess, RecipeHolder<?> recipe, NonNullList<ItemStack> inventory, int maxStackSize) {
        if (!((ItemStack)inventory.get(0)).isEmpty() && recipe != null) {
            ItemStack itemstack = recipe.value().getResultItem((HolderLookup.Provider)registryAccess);
            if (itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)inventory.get(2);
            if (itemstack1.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemstack1, (ItemStack)itemstack)) {
                return false;
            }
            return itemstack1.getCount() < maxStackSize && itemstack1.getCount() < itemstack1.getMaxStackSize() || itemstack1.getCount() < itemstack.getMaxStackSize();
        }
        return false;
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"avp.industrialfurnace.displayName");
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory) {
        return new IndustrialFurnaceMenu(i, inventory, (Container)this, this.dataAccess);
    }
}

