/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity.power.impl;

import com.alien.common.data.AlienVariantTypes;
import com.avp.AVP;
import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.avp.common.registry.tag.AVPBlockTags;
import com.human.common.gameplay.block.entity.power.PowerConsumerBlockEntity;
import com.human.common.gameplay.block.entity.power.impl.ResonatorAnimationDispatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ResonatorBlockEntity
extends PowerConsumerBlockEntity {
    private int tickCounter = 0;
    private final ResonatorAnimationDispatcher animationDispatcher = new ResonatorAnimationDispatcher();
    private final Map<Item, Integer> resinBallCounts = new HashMap<Item, Integer>();

    public ResonatorBlockEntity(BlockPos pos, BlockState blockState) {
        super(AVPBlockEntityTypes.RESONATOR.get(), pos, blockState);
    }

    @Override
    public long getRequestedPower() {
        return 1000L;
    }

    @Override
    public void unpoweredTick(Level level, BlockPos blockPos, BlockState blockState) {
        this.animationDispatcher.unpowered(this);
    }

    @Override
    public void poweredTick(Level level, BlockPos blockPos, BlockState blockState) {
        this.animationDispatcher.powered(this);
        ++this.tickCounter;
        int tickValue = AVP.config.blockConfigs.RESONATOR_REPLACE_TICKS;
        if (this.tickCounter % tickValue != 0) {
            return;
        }
        int radius = AVP.config.blockConfigs.RESONATOR_REPLACE_RADIUS;
        BlockPos.betweenClosedStream((BlockPos)blockPos.offset(-radius, -radius, -radius), (BlockPos)blockPos.offset(radius, radius, radius)).forEach(currentPos -> {
            BlockState currentState = level.getBlockState(currentPos);
            AlienVariantTypes.getFor(currentState).ifSome(alienVariantType -> {
                if (currentState.is(AVPBlockTags.RESIN_VEINS)) {
                    level.setBlockAndUpdate(currentPos, Blocks.AIR.defaultBlockState());
                    Item resinBallItem = alienVariantType.resinBall().get();
                    this.addResinBallItem(resinBallItem);
                    this.setChanged();
                    return;
                }
                if (currentState.is(AVPBlockTags.RESIN)) {
                    Block replacementBlock = currentPos.getY() <= 0 ? Blocks.DEEPSLATE : Blocks.STONE;
                    level.setBlockAndUpdate(currentPos, replacementBlock.defaultBlockState());
                    Item resinBallItem = alienVariantType.resinBall().get();
                    this.addResinBallItem(resinBallItem);
                    this.setChanged();
                }
            });
        });
    }

    public void addResinBallItem(Item resinBallItem) {
        this.resinBallCounts.merge(resinBallItem, 1, Integer::sum);
        this.setChanged();
    }

    public Map<Item, Integer> getResinBallCounts() {
        return Collections.unmodifiableMap(this.resinBallCounts);
    }

    public void onRightClick(Player player) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (!this.resinBallCounts.isEmpty()) {
            for (Map.Entry<Item, Integer> entry : this.resinBallCounts.entrySet()) {
                Item resinBallItem = entry.getKey();
                Integer count = entry.getValue();
                if (count <= 0) continue;
                ItemStack resinBallStack = new ItemStack((ItemLike)resinBallItem, count.intValue());
                ItemEntity resinBallEntity = new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), resinBallStack);
                this.level.addFreshEntity((Entity)resinBallEntity);
            }
            this.resinBallCounts.clear();
            this.setChanged();
        }
    }
}

