/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity.power.impl;

import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.human.common.gameplay.block.entity.power.PowerNodeBlockEntity;
import com.human.common.gameplay.power.PowerNode;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;

public class SolarPanelBlockEntity
extends PowerNodeBlockEntity
implements PowerNode.PowerProducer {
    private static final int MC_DAY_LENGTH_IN_TICKS = 24000;
    private static final int MC_START_OF_DUSK_IN_TICKS = 12000;
    private static final int MC_START_OF_NIGHT_IN_TICKS = 14000;
    private static final int MC_START_OF_DAWN_IN_TICKS = 23000;
    private static final int MC_START_OF_DAY_IN_TICKS = 1000;

    public SolarPanelBlockEntity(BlockPos pos, BlockState state) {
        super(AVPBlockEntityTypes.SOLAR_PANEL.get(), pos, state);
    }

    @Override
    public long getAvailablePower() {
        if (this.level == null || this.level.isClientSide) {
            return 0L;
        }
        BlockPos abovePos = this.getBlockPos().above();
        if (!this.level.canSeeSky(abovePos)) {
            return 0L;
        }
        int skyLight = this.level.getBrightness(LightLayer.SKY, abovePos);
        if (skyLight == 0) {
            return 0L;
        }
        int baseOutput = skyLight * 10;
        double sunlightFactor = this.computeSunlightFactor(this.level);
        double weatherFactor = 1.0;
        if (this.level.isThundering()) {
            weatherFactor = 0.2;
        } else if (this.level.isRaining()) {
            weatherFactor = 0.5;
        }
        return (long)((double)baseOutput * sunlightFactor * weatherFactor);
    }

    private double computeSunlightFactor(Level level) {
        long timeOfDay = level.getDayTime() % 24000L;
        double sunlightFactor = timeOfDay <= 1000L ? Mth.map((double)timeOfDay, (double)0.0, (double)1000.0, (double)0.5, (double)1.0) : (timeOfDay <= 12000L ? 1.0 : (timeOfDay <= 14000L ? (double)Mth.map((float)(14000L - timeOfDay), (float)0.0f, (float)2000.0f, (float)0.0f, (float)1.0f) : (timeOfDay <= 23000L ? 0.0 : Mth.map((double)timeOfDay, (double)23000.0, (double)23999.0, (double)0.0, (double)0.5))));
        return sunlightFactor;
    }

    @Override
    public long extractPower(long maxAmount) {
        return maxAmount;
    }
}

