/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.power;

import com.human.common.gameplay.block.entity.power.impl.DeskTerminalBlockEntity;
import com.human.common.gameplay.block.power.PowerNodeEntityBlock;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeskTerminalBlock
extends PowerNodeEntityBlock<DeskTerminalBlockEntity> {
    public static final MapCodec<DeskTerminalBlock> CODEC = DeskTerminalBlock.simpleCodec(DeskTerminalBlock::new);
    public static final DirectionProperty FACING = DirectionalBlock.FACING;

    public DeskTerminalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        VoxelShape southShape = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)6.0, (double)15.0, (double)13.0, (double)17.0), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)2.0, (double)7.0), (BooleanOp)BooleanOp.OR);
        return switch (facing) {
            case Direction.EAST -> DeskTerminalBlock.rotateShape(southShape, Rotation.CLOCKWISE_90);
            case Direction.WEST -> DeskTerminalBlock.rotateShape(southShape, Rotation.COUNTERCLOCKWISE_90);
            case Direction.SOUTH -> DeskTerminalBlock.rotateShape(southShape, Rotation.CLOCKWISE_180);
            default -> southShape;
        };
    }

    public static VoxelShape rotateShape(VoxelShape shape, Rotation rotation) {
        List aabbList = shape.toAabbs();
        VoxelShape[] rotatedShapes = (VoxelShape[])aabbList.stream().map(box -> DeskTerminalBlock.rotateBox(box, rotation)).map(Shapes::create).toArray(VoxelShape[]::new);
        VoxelShape combined = Shapes.empty();
        for (VoxelShape rotatedShape : rotatedShapes) {
            combined = Shapes.or((VoxelShape)combined, (VoxelShape)rotatedShape);
        }
        return combined;
    }

    public static AABB rotateBox(AABB box, Rotation rotation) {
        double x1 = box.minX;
        double y1 = box.minY;
        double z1 = box.minZ;
        double x2 = box.maxX;
        double y2 = box.maxY;
        double z2 = box.maxZ;
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new AABB(1.0 - z2, y1, x1, 1.0 - z1, y2, x2);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(z1, y1, 1.0 - x2, z2, y2, 1.0 - x1);
            case Rotation.CLOCKWISE_180 -> new AABB(1.0 - x2, y1, 1.0 - z2, 1.0 - x1, y2, 1.0 - z1);
            default -> box;
        };
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new DeskTerminalBlockEntity(blockPos, blockState);
    }
}

