/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.power;

import com.human.common.gameplay.block.entity.power.PowerNodeBlockEntity;
import com.human.common.gameplay.block.power.CableBlock;
import com.human.common.gameplay.power.PowerNode;
import com.human.common.gameplay.power.PowerSystem;
import com.human.common.gameplay.power.grid.PowerGridManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PowerNodeEntityBlock<T extends PowerNodeBlockEntity>
extends BaseEntityBlock {
    public PowerNodeEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<U> blockEntityType) {
        return level.isClientSide ? null : PowerNodeEntityBlock.createTickerHelper(blockEntityType, blockEntityType, (lvl, pos, state, be) -> be.serverTick(lvl, pos, state));
    }

    protected void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        if (level.isClientSide) {
            return;
        }
        PowerGridManager manager = PowerSystem.get((ServerLevel)level);
        for (Direction direction : Direction.values()) {
            BlockPos neighbor = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighbor);
            if (!(neighborState.getBlock() instanceof CableBlock) && !(level.getBlockEntity(neighbor) instanceof PowerNode)) continue;
            manager.union(pos, neighbor);
        }
    }

    protected void onRemove(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        if (!level.isClientSide && state.getBlock() != newState.getBlock()) {
            PowerSystem.get((ServerLevel)level).splitGrid(level, pos);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

