/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.power;

import com.human.common.gameplay.block.entity.power.impl.ResonatorBlockEntity;
import com.human.common.gameplay.block.power.PowerNodeEntityBlock;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResonatorBlock
extends PowerNodeEntityBlock<ResonatorBlockEntity> {
    public static final MapCodec<ResonatorBlock> CODEC = ResonatorBlock.simpleCodec(ResonatorBlock::new);

    public ResonatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ResonatorBlockEntity(blockPos, blockState);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof ResonatorBlockEntity) {
            ResonatorBlockEntity resonatorBlockEntity = (ResonatorBlockEntity)blockEntity;
            resonatorBlockEntity.onRightClick(player);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onRemove(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ResonatorBlockEntity) {
                ResonatorBlockEntity resonatorBlockEntity = (ResonatorBlockEntity)blockEntity;
                resonatorBlockEntity.getResinBallCounts().forEach((resinBallItem, count) -> {
                    if (count > 0) {
                        ItemStack resinBallStack = new ItemStack((ItemLike)resinBallItem, count.intValue());
                        ItemEntity resinBallEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, resinBallStack);
                        level.addFreshEntity((Entity)resinBallEntity);
                    }
                });
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }
}

