/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.nuke;

import com.human.common.gameplay.entity.nuke.MushroomCloudAnimDispatcher;
import com.human.common.registry.init.entity_type.HumanEntityTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MushroomCloudEntity
extends Entity {
    protected MushroomCloudAnimDispatcher animDispatcher;

    public MushroomCloudEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
        this.animDispatcher = new MushroomCloudAnimDispatcher(this);
    }

    public MushroomCloudEntity(Level level, double x, double y, double z) {
        super(HumanEntityTypes.MUSHROOM_CLOUD.get(), level);
        this.animDispatcher = new MushroomCloudAnimDispatcher(this);
        this.setPos(x, y, z);
    }

    public void tick() {
        super.tick();
        if (this.tickCount >= 180) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (!this.level().isClientSide() && this.tickCount == 2) {
            this.animDispatcher.explode();
        }
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
    }
}

