/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.projectile;

import com.avp.common.gameplay.effect.RadiationStatusEffect;
import com.avp.common.gameplay.entity.projectile.BouncingItemProjectile;
import com.avp.common.registry.init.AVPMobEffects;
import com.avp.common.registry.init.item.AVPItems;
import com.human.common.registry.init.entity_type.HumanEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ThrownGrenade
extends BouncingItemProjectile {
    private static final String IS_INCENDIARY_KEY = "IsIncendiary";
    private static final String IS_IRRADIATED_KEY = "IsIrradiated";
    private boolean isIncendiary;
    private boolean isIrradiated;

    public ThrownGrenade(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.shouldBounce = true;
        this.maxLife = 100;
    }

    public ThrownGrenade(Level level, LivingEntity livingEntity) {
        super(HumanEntityTypes.GRENADE_THROWN.get(), livingEntity, level);
        this.shouldBounce = true;
        this.maxLife = 100;
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        Vec3 pos = this.position();
        double posX = pos.x;
        double posY = pos.y;
        double posZ = pos.z;
        if (this.firstTick) {
            this.playSound(SoundEvents.TNT_PRIMED, 1.0f, 1.0f);
        }
        if (level.isClientSide) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, posX, posY + 0.5, posZ, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        if (this.isIrradiated) {
            return AVPItems.GRENADE_IRRADIATED.get();
        }
        if (this.isIncendiary) {
            return AVPItems.GRENADE_INCENDIARY.get();
        }
        return AVPItems.GRENADE.get();
    }

    @Override
    protected void onDeath() {
        Level level = this.level();
        if (level.isClientSide) {
            return;
        }
        level.explode((Entity)this, this.getX(), this.getY(), this.getZ(), this.isIrradiated ? 9.0f : 3.0f, this.isIncendiary, Level.ExplosionInteraction.BLOCK);
        if (this.isIrradiated) {
            this.createIrradiatedCloudEffect(level);
        }
    }

    private void createIrradiatedCloudEffect(Level level) {
        BlockPos blockPos = this.blockPosition();
        AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        areaEffectCloudEntity.setRadius(10.0f);
        areaEffectCloudEntity.setDuration(100);
        areaEffectCloudEntity.setRadiusPerTick(-areaEffectCloudEntity.getRadius() / (float)areaEffectCloudEntity.getDuration());
        areaEffectCloudEntity.setParticle((ParticleOptions)ParticleTypes.ASH);
        areaEffectCloudEntity.addEffect(new MobEffectInstance(AVPMobEffects.RADIATION.getHolder(), RadiationStatusEffect.EFFECT_DURATION_IN_TICKS, 0));
        level.addFreshEntity((Entity)areaEffectCloudEntity);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.isIncendiary = compoundTag.getBoolean(IS_INCENDIARY_KEY);
        this.isIrradiated = compoundTag.getBoolean(IS_IRRADIATED_KEY);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean(IS_INCENDIARY_KEY, this.isIncendiary);
        compoundTag.putBoolean(IS_IRRADIATED_KEY, this.isIncendiary);
    }

    public void setIncendiary(boolean incendiary) {
        this.isIncendiary = incendiary;
    }

    public void setIrradiated(boolean isIrradiated) {
        this.isIrradiated = isIrradiated;
    }
}

