/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item;

import com.avp.common.registry.init.item.AVPItems;
import com.human.common.gameplay.item.gun.FireModeConfig;
import com.human.common.gameplay.item.gun.GunConfig;
import com.human.common.gameplay.item.gun.pipeline.GunShootContext;
import com.human.common.registry.init.HumanDataComponents;
import com.human.common.registry.init.item.HumanGunItems;
import com.lib.common.gameplay.util.TooltipUtil;
import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.rewrite.animation.play_behavior.AzPlayBehaviors;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GunItem
extends Item {
    protected static final int START_TICK_PROGRESS = Integer.MAX_VALUE;
    private final GunConfig gunConfig;
    public AzCommand idle;
    public AzCommand shoot;
    public static final AzCommand reload = AzCommand.create((String)"main", (String)"animation.reload", (AzPlayBehavior)AzPlayBehaviors.PLAY_ONCE);

    public GunItem(GunConfig gunConfig) {
        super(new Item.Properties().stacksTo(1).component(HumanDataComponents.IS_FIRING.get(), (Object)false).durability(gunConfig.durability()).attributes(GunItem.createAttributes()));
        this.gunConfig = gunConfig;
        this.idle = AzCommand.create((String)"main", (String)"animation.idle", (AzPlayBehavior)AzPlayBehaviors.LOOP);
        this.shoot = AzCommand.create((String)"main", (String)"animation.shoot", (AzPlayBehavior)AzPlayBehaviors.PLAY_ONCE);
    }

    private static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-0.1f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    protected void playReleaseUsingAnimations(Entity shooter, ItemStack itemStack) {
        this.idle.sendForItem(shooter, itemStack);
    }

    protected void playUseAnimations(Entity shooter, ItemStack itemStack) {
        this.shoot.sendForItem(shooter, itemStack);
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, ItemStack repairIngredient) {
        return repairIngredient.is(AVPItems.STEEL_INGOT.get());
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public void releaseUsing(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int i) {
        FireModeConfig fireModeConfig = this.gunConfig.getDefaultFireMode();
        Supplier<SoundEvent> shootFinishSoundEvent = fireModeConfig.shootFinishSoundEvent();
        if (shootFinishSoundEvent != null) {
            level.playSound(null, livingEntity.blockPosition(), shootFinishSoundEvent.get(), SoundSource.PLAYERS);
        }
        this.playReleaseUsingAnimations((Entity)livingEntity, itemStack);
        super.releaseUsing(itemStack, level, livingEntity, i);
    }

    public void onUseTick(@NotNull Level level, @NotNull LivingEntity livingEntity, @NotNull ItemStack itemStack, int tickCountdown) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int tickProgress = Math.abs(Integer.MAX_VALUE - tickCountdown);
        GunShootContext.create((LivingEntity)player, itemStack, tickProgress).map(GunShootContext::shoot).ifSome(result -> {
            switch (result) {
                case COOLDOWN: 
                case DELAYED: 
                case FAILURE: 
                case RELOADING: {
                    break;
                }
                case SHOT: {
                    itemStack.set(HumanDataComponents.IS_FIRING.get(), (Object)true);
                    this.playUseAnimations((Entity)livingEntity, itemStack);
                }
            }
        });
    }

    public int getUseDuration(@NotNull ItemStack itemStack, @NotNull LivingEntity livingEntity) {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
    }

    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int i, boolean bl) {
        LivingEntity livingEntity;
        Boolean isFiring = (Boolean)itemStack.get(HumanDataComponents.IS_FIRING.get());
        if (Boolean.TRUE.equals(isFiring) && entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).isUsingItem()) {
            itemStack.set(HumanDataComponents.IS_FIRING.get(), (Object)false);
            this.playReleaseUsingAnimations((Entity)livingEntity, itemStack);
        }
        super.inventoryTick(itemStack, level, entity, i, bl);
    }

    public GunConfig getGunConfig() {
        return this.gunConfig;
    }

    public void appendHoverText(@NotNull ItemStack itemStack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
        int currentAmmunition = (Integer)itemStack.getOrDefault(HumanDataComponents.AMMUNITION.get(), (Object)0);
        FireModeConfig fireMode = this.gunConfig.getDefaultFireMode();
        Supplier<ItemLike> itemSupplier = this.gunConfig.ammunitionItemSupplier();
        if (itemSupplier != null) {
            ItemLike item = itemSupplier.get();
            TooltipUtil.appendLabel(list, "tooltip.avp.ammunition_type", Component.translatable((String)item.asItem().getDescriptionId()));
        }
        if (this != HumanGunItems.OLD_PAINLESS.get()) {
            TooltipUtil.appendLabel(list, "tooltip.avp.ammunition", Component.literal((String)(currentAmmunition + " / " + this.gunConfig.maximumAmmunition())));
        }
        TooltipUtil.appendLabel(list, "tooltip.avp.damage", Component.literal((String)ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(fireMode.damage())));
        TooltipUtil.appendLabel(list, "tooltip.avp.knockback", Component.literal((String)ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(fireMode.knockback())));
        TooltipUtil.appendLabel(list, "tooltip.avp.fire_rate", Component.literal((String)(ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format((double)fireMode.cooldownInTicks() / 20.0) + " / Sec")));
    }
}

